//                                               -*- C++ -*-
/**
 *  @file  Greater.cxx
 *  @brief Abstract top-level class for all Greater
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: Greater.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "Greater.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(Greater);

      static Common::Factory<Greater> RegisteredFactory("Greater");

      /* Default constructor */
      Greater::Greater()
	: ComparisonOperatorImplementation()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* String converter */
      String Greater::str() const {
	return OSS() << "class=" << Greater::GetClassName()
		     << " name=" << getName();
      }
  

      /* Here is the interface that all derived class must implement */

      /* Virtual constructor */
      Greater * Greater::clone() const
      {
	return new Greater(*this);
      }

      /* Return true if comparison succeeds */
      Bool Greater::operator() (NumericalScalar a, NumericalScalar b) const
      {
	return (a > b);
      }

      /* Method save() stores the object through the StorageManager */
      void Greater::save(const StorageManager::Advocate & adv) const
      {
	ComparisonOperatorImplementation::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void Greater::load(const StorageManager::Advocate & adv)
      {
	ComparisonOperatorImplementation::load(adv);
      }





    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
