//                                               -*- C++ -*-
/**
 *  @file  PersistentObjectFactory.cxx
 *  @brief Class PersistentObjectFactory saves and reloads the object's internal state
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: PersistentObjectFactory.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "PersistentObjectFactory.hxx"
#include "Catalog.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /* Virtual constructor */
      // PersistentObjectFactory * PersistentObjectFactory::clone() const = 0


      /* Destructor */
      PersistentObjectFactory::~PersistentObjectFactory()
      {
        // Nothing to do
      }


      /* This method register the factory into the Catalog */
      void PersistentObjectFactory::registerMe(const String & className) const
      {
	Catalog::GetInstance().add(className, this);	
      }


      /* Method build() creates a new PersistentObject from the storage manager */
      // PersistentObject * PersistentObjectFactory::build(const StorageManager & mgr) const = 0;


      /* Accessor to PersistentObject's shadowed id */
      void PersistentObjectFactory::setShadowedId(PersistentObject & obj, Id id) const
      {
	obj.setShadowedId(id);
      }

      Id PersistentObjectFactory::getShadowedId(PersistentObject & obj) const
      {
	return obj.getShadowedId();
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
