//                                               -*- C++ -*-
/**
 *  @file  ThreadStatus.cxx
 *  @brief The class ThreadStatus is the top-most class of Open TURNS
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: ThreadStatus.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "ThreadStatus.hxx"
#include "OSS.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(ThreadStatus);

      /* Default constructor */
      ThreadStatus::ThreadStatus()
	: Object()
      {
        // Nothing to do
      }

      /* String converter */
      String ThreadStatus::str() const
      {
	return OSS() << "class=" << getClassName();
      }




    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
