//                                               -*- C++ -*-
/**
 * @file  ComposedNumericalMathEvaluationImplementation.hxx
 * @brief The class that implements the composition between numerical
 *        math functions implementations
 *
 * (C) Copyright 2005-2006 EADS
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 */

#ifndef OPENTURNS_COMPOSEDNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_COMPOSEDNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ComposedNumericalMathEvaluationImplementation
       *
       * The class that implement the composition of two numerical math functions implementations.
       */
      class ComposedNumericalMathEvaluationImplementation 
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef NumericalMathEvaluationImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathEvaluationImplementation::NumericalSample          NumericalSample;
	typedef Common::Pointer<NumericalMathEvaluationImplementation>          EvaluationImplementation;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException        InternalException;
	typedef NumericalMathEvaluationImplementation::NumericalPointWithDescription NumericalPointWithDescription;

	/** Default constructor */
	ComposedNumericalMathEvaluationImplementation(const EvaluationImplementation & p_leftFunction,
						      const EvaluationImplementation & p_rightFunction) throw(InvalidArgumentException);


	/** Virtual constructor */
	virtual ComposedNumericalMathEvaluationImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ComposedNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String str() const;

	/** Operator () */
	NumericalPoint operator() (const NumericalPoint & in) const
	  throw(InvalidArgumentException,InternalException);

	NumericalSample operator() (const NumericalSample & in) const
	  throw(InvalidArgumentException,InternalException);

	/** Parameters value and description accessor */
	virtual NumericalPointWithDescription getParameters() const;
	virtual void setParameters(const NumericalPointWithDescription & parameters);

	/** Accessor for input point dimension */
	UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      protected:

	ComposedNumericalMathEvaluationImplementation() {};
	friend class Common::Factory<ComposedNumericalMathEvaluationImplementation>;
    
      private:

	/** The function f in h = f o g */
	EvaluationImplementation p_leftFunction_;

	/** The function g in h = f o g */
	EvaluationImplementation p_rightFunction_;

      }; /* class ComposedNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPOSEDNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
