//                                               -*- C++ -*-
/**
 *  @file  ConstantNumericalMathHessianImplementation.hxx
 *  @brief Class for a constant numerical math hessian implementation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: ConstantNumericalMathHessianImplementation.hxx 995 2008-10-31 10:52:04Z dutka $
 */
#ifndef OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "Exception.hxx"
#include "SymmetricTensor.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ConstantNumericalMathHessianImplementation
       *
       * This class offers an interface for a real numerical mathematical hessian
       * implementations into the platform. It realizes the computation of the image symmetric tensor
       * of a vector (aka NumericalPoint) through the hessian.
       */
      class ConstantNumericalMathHessianImplementation
	: public NumericalMathHessianImplementation
      {
	CLASSNAME;
      public:

	typedef NumericalMathHessianImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathHessianImplementation::InternalException        InternalException;
	typedef NumericalMathHessianImplementation::SymmetricTensor          SymmetricTensor;
	typedef NumericalMathHessianImplementation::StorageManager           StorageManager;
	typedef Common::InvalidDimensionException                            InvalidDimensionException;

	/** Default constructor */
	ConstantNumericalMathHessianImplementation();

	/** Parameter constructor */
	ConstantNumericalMathHessianImplementation(const SymmetricTensor & constant)
	  throw(InvalidDimensionException);


	/** Virtual constructor */
	virtual ConstantNumericalMathHessianImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ConstantNumericalMathHessianImplementation & other) const;

	/** String converter */
	virtual String str() const;

	/* Here is the interface that all derived class must implement */
	
	/** Hessian method */
	virtual SymmetricTensor hessian(const NumericalPoint & in) const
	  throw(InvalidArgumentException, InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
          throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for the constant term */
	SymmetricTensor getConstant() const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      protected:

    
      private:
	SymmetricTensor constant_;
      }; /* class ConstantNumericalMathHessianImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX */
