//                                               -*- C++ -*-
/**
 *  @file  LinearNumericalMathFunction.cxx
 *  @brief Abstract top-level class for all distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-22 11:34:11 +0200 (lun 22 sep 2008) $
 *  Id:      $Id: LinearNumericalMathFunction.cxx 941 2008-09-22 09:34:11Z dutka $
 */
#include "LinearNumericalMathFunction.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(LinearNumericalMathFunction);

      /* Default constructor */
      LinearNumericalMathFunction::LinearNumericalMathFunction(const NumericalPoint & center,
							       const NumericalPoint & constant,
							       const Matrix & linear)
	: NumericalMathFunction(new LinearNumericalMathEvaluationImplementation(center, constant, linear.transpose()), 
				new ConstantNumericalMathGradientImplementation(linear.transpose()),
				new ConstantNumericalMathHessianImplementation(SymmetricTensor(center.getDimension(), constant.getDimension())))
      {
	// Nothing to do
      }

      /* Comparison operator */
      Bool LinearNumericalMathFunction::operator ==(const LinearNumericalMathFunction & other) const
      {
	return true;
      }
  
      /* String converter */
      String LinearNumericalMathFunction::str() const
      {
	OSS oss;
	oss << "class=" << LinearNumericalMathFunction::GetClassName()
	    << " name=" << getName()
            << " implementation=" << getImplementation()->str();
	return oss;
      }
  
    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
