//                                               -*- C++ -*-
/**
 *  @file  WrapperFile.hxx
 *  @brief This class provides all the treatments for wrapper file manipulation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-29 18:54:45 +0100 (mer 29 oct 2008) $
 *  Id:      $Id: WrapperFile.hxx 990 2008-10-29 17:54:45Z dutka $
 */
#ifndef OPENTURNS_WRAPPERFILE_HXX
#define OPENTURNS_WRAPPERFILE_HXX

#include <iostream>              // for std::ostream
#include "OT.hxx"
#include "PersistentObject.hxx"
#include "WrapperData.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {


      /**
       * @class WrapperFile
       *
       * This class provides all the treatments for wrapper file manipulation
       */

      class WrapperFile
	: public Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Common::NoWrapperFileFoundException NoWrapperFileFoundException;
	typedef Common::WrapperFileParsingException WrapperFileParsingException;

	/**
	 * Find the path of a wrapper file from its name.
	 */
	static FileName FindWrapperPathByName(const String & name)
	  throw(NoWrapperFileFoundException);

	/**
	 * Build a wrapper from a name
	 */
	static WrapperFile FindWrapperByName(const String & name)
	  throw(NoWrapperFileFoundException);

      protected:

	/** The file name extension */
	static const String extension_;

	/** The environment variable name */
	static const String openturnsWrapperPathVariableName_;
	
	/** The HOME subdirectory path */
	static const String homeSubdirectory_;
	
	/** The 'prefix' subdirectory path */
	static const String prefixSubdirectory_;




      public:

	/** 
	 * Default constructor
	 */
	explicit WrapperFile(const FileName & pathToFile)
	  throw(WrapperFileParsingException);

	/** Virtual constructor */
	virtual WrapperFile * clone() const;

	/** String converter */
	virtual String str() const;

	/** Description file path accessor */
	void setDescriptionFilePath(const FileName & path);
	FileName getDescriptionFilePath() const;

	/** Wrapper data accessor */
	void setWrapperData(const WrapperData & data);
	const WrapperData & getWrapperData() const;


      protected:

	/** Where the description file of the wrapper is located */
	FileName descriptionFilePath_;

	/** The data that the wrapper may exchange with the platform */
	WrapperData data_;

      private:

	/** Initialization */
	void init() const
	  throw(WrapperFileParsingException);

	/** Finalization */
	void done() const;

	/** Parsing function */
	void parseFile(const FileName & pathToFile)
	  throw(WrapperFileParsingException);

      }

      ; /* class WrapperFile */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_WRAPPERFILE_HXX */
