//                                               -*- C++ -*-
/**
 *  @file  BarPlot.hxx
 *  @brief BarPlot class for barplots
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: BarPlot.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_BARPLOT_HXX
#define OPENTURNS_BARPLOT_HXX

#include "OT.hxx"
#include "DrawableImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class BarPlot
       *
       * The class describing a curve plot
       * Instance of Drawable
       */


      class BarPlot : public DrawableImplementation
      {

	CLASSNAME;

      public:
	
	typedef DrawableImplementation::NumericalSample          NumericalSample;
	typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;
	typedef DrawableImplementation::StorageManager           StorageManager;
	
	/** Default constructor */
	BarPlot(const NumericalSample & data,
		const NumericalScalar origin,
		const String & legend = NoSpecifiedLabel);

	/** Constructor with parameters */
	BarPlot(const NumericalSample & data,
		const NumericalScalar origin,
		const String & color,
		const String & fillStyle,
		const String & lineStyle,
		const String & legend = NoSpecifiedLabel)
	  throw(InvalidArgumentException);

	/** String converter */
	String str() const;

	/** Accessor for origin */
	NumericalScalar getOrigin() const;
	void setOrigin(const NumericalScalar origin);

	/** Accessor for boundingbox */
	BoundingBox getBoundingBox() const;

	/** Draw method */
	String draw() const;

	/** Clone method */
	BarPlot * clone() const;

	/** Check fo data validity */
	Bool isValidData(const NumericalSample & data) const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

 	/** Method load() stores the object through the StorageManager */
	void load(const StorageManager::Advocate & adv);

      private:

	BarPlot() {};
	friend class Base::Common::Factory<BarPlot>;

	/** Origin of the BarPlot */
	NumericalScalar origin_;

      }; /* class BarPlot */

    }/* namespace Graph */

  }/*namespace Base */

}/* namespace OpenTURNS */

#endif /* OPENTURNS_BARPLOT_HXX */
