//                                               -*- C++ -*-
/**
 *  @file  AbdoRackwitzSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the AbdoRackwitz specific
 *         parameters.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-09-10 15:54:48 +0200 (lun 10 sep 2007) $
 *  Id:      $Id: AbdoRackwitzSpecificParameters.cxx 503 2007-09-10 13:54:48Z dutka $
 */

#include "AbdoRackwitz.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optimisation
    {

      /* Multiplicative decrease of linear step */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultTau = 0.5;
      /* Armijo factor */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultOmega = 1e-4;
      /* Growing factor in penalization term */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultSmooth = 1.2;

      CLASSNAMEINIT(AbdoRackwitz::SpecificParameters);

      /* Default onstructor */
      AbdoRackwitz::SpecificParameters::SpecificParameters():
	PersistentObject(),
	tau_(AbdoRackwitz::SpecificParameters::DefaultTau),
	omega_(AbdoRackwitz::SpecificParameters::DefaultOmega),
	smooth_(AbdoRackwitz::SpecificParameters::DefaultSmooth)
      {
	// Nothing to do
      } /* SpecificParametersAbdoRackwitz */

      /* Constructor with parameters */
      AbdoRackwitz::SpecificParameters::SpecificParameters(const NumericalScalar tau,
							   const NumericalScalar omega,
							   const NumericalScalar smooth):
	PersistentObject(),
	tau_(tau),
	omega_(omega),
	smooth_(smooth)
      {
	// Nothing to do
      } /* SpecificParametersAbdoRackwitz */

      /* Virtual constructor */
      AbdoRackwitz::SpecificParameters * AbdoRackwitz::SpecificParameters::clone() const
      {
	return new SpecificParameters(*this);
      }

      /* Tau accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getTau() const
      {
	return tau_;
      }

      /* Tau accessor */
      void AbdoRackwitz::SpecificParameters::setTau(const NumericalScalar tau)
      {
        tau_ = tau;
      }

      /* Omega accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getOmega() const
      {
	return omega_;
      }

      /* Omega accessor */
      void AbdoRackwitz::SpecificParameters::setOmega(const NumericalScalar omega)
      {
        omega_ = omega;
      }

      /* Smooth accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getSmooth() const
      {
	return smooth_;
      }

      /* Smooth accessor */
      void AbdoRackwitz::SpecificParameters::setSmooth(const NumericalScalar smooth)
      {
        smooth_ = smooth;
      }

      /* String converter */
      String AbdoRackwitz::SpecificParameters::str() const
      {
	OSS oss;
	oss << "class=" << AbdoRackwitz::SpecificParameters::GetClassName()
            << " tau=" << tau_
            << " omega=" << omega_
            << " smooth=" << smooth_;
	return oss;
      }

    } /* namespace Optimisation */
  } /* namespace Base */
} /* namespace OpenTURNS */



