//                                               -*- C++ -*-
/**
 * @file  CorrelationAnalysis.hxx
 * @brief CorrelationAnalysis implements the sensitivity analysis methods based on correlation coefficients
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 */

#ifndef OPENTURNS_CORRELATIONANALYSIS_HXX
#define OPENTURNS_CORRELATIONANALYSIS_HXX

#include "OT.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      /**
       * @class CorrelationAnalysis
       *
       */

      class CorrelationAnalysis
      {
      public:

	typedef Base::Stat::NumericalSample NumericalSample;
	typedef Base::Type::NumericalPoint  NumericalPoint;

	/** Compute the Pearson correlation coefficient between the component number index of the input sample and the 1D outputSample */
	static NumericalScalar PearsonCorrelation(const NumericalSample & inputSample,
                				  const NumericalSample & outputSample,
                                                  const UnsignedLong index = 0);

	/** Compute the Spearman correlation coefficient between the component number index of the input sample and the 1D outputSample */
	static NumericalScalar SpearmanCorrelation(const NumericalSample & inputSample,
						   const NumericalSample & outputSample,
						   const UnsignedLong index = 0);

	/** Compute the Standard Regression Coefficients (SRC) between the input sample and the output sample */
	static NumericalPoint SRC(const NumericalSample & inputSample,
				  const NumericalSample & outputSample);

	/** Compute the Partial Correlation Coefficients (PCC) between the input sample and the output sample */
	static NumericalPoint PCC(const NumericalSample & inputSample,
				  const NumericalSample & outputSample);

	/** Compute the Standard Rank Regression Coefficients (SRRC) between the input sample and the output sample */
	static NumericalPoint SRRC(const NumericalSample & inputSample,
				   const NumericalSample & outputSample);

	/** Compute the Partial Rank Correlation Coefficients (PRCC) between the input sample and the output sample */
	static NumericalPoint PRCC(const NumericalSample & inputSample,
				   const NumericalSample & outputSample);

      }; /* class CorrelationAnalysis */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_CORRELATIONANALYSIS_HXX */
