//                                               -*- C++ -*-
/**
 *  @file  CorrelationMatrix.cxx
 *  @brief The class CorrelationMatrix implements correlation matrices
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: CorrelationMatrix.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "CorrelationMatrix.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      CLASSNAMEINIT(CorrelationMatrix);

      /* Default constructor */
      CorrelationMatrix::CorrelationMatrix()
	: CovarianceMatrix(0)
      {
        // Nothing to do
      }
      
      /* Constructor with size (dim, which is the same for nbRows_ and nbColumns_ )*/
      CorrelationMatrix::CorrelationMatrix(UnsignedLong dim)
	: CovarianceMatrix(dim)
      {
	// Initialize the correlation matrix to the identity matrix
	for(UnsignedLong i = 0; i < dim; i++)
	  this->operator()(i, i) = 1.0;
      }
      
      /* Constructor from external collection */
      /* If the dimensions of the matrix and of the collection */
      /* do not match, either the collection is truncated */
      /* or the rest of the matrix is filled with zeros */
      CorrelationMatrix::CorrelationMatrix(UnsignedLong dim, 
					   const OT::Base::Type::Collection<NumericalScalar> &elementsValues)
	: CovarianceMatrix(dim, elementsValues)
      {
        // Nothing to do
      }
      
      /* Constructor with implementation */
      CorrelationMatrix::CorrelationMatrix(const Implementation & i)
	: CovarianceMatrix(i) 
      {
      }
      
      /* String converter */
      String CorrelationMatrix::str() const
      {
	checkSymmetry();
	return OSS() << "class=" << getClassName()
		     << " dimension=" << this->getDimension()
		     << " implementation=" << getImplementation()->str();
      }

      /* CorrelationMatrix transpose */
      CorrelationMatrix CorrelationMatrix::transpose () const 
      { 
        return *this;
      }
      
      /* CorrelationMatrix multiplication (must have consistent dimensions) */
      CorrelationMatrix CorrelationMatrix::operator * (const IdentityMatrix & m) const throw(InvalidDimensionException)
      {
        return *this;
      }
      
    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
