//                                               -*- C++ -*-
/**
 *  @file  Indices.cxx
 *  @brief Set of indices defined as a Collection of UnsignedLong class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: Indices.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <algorithm>
#include "Indices.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Type {

      /* Check that no value is repeated and no value exceed the given bound */
      Bool Indices::check(const UnsignedLong bound) const
      {
	// Check if the values are all different
	Indices copy(*this);
	std::sort(copy.begin(), copy.end());
	iterator iter = std::unique(copy.begin(), copy.end());
	if (iter < copy.end()) return false;
	// Check if the values are in the given bound
	if (*max_element(begin(), end()) > bound) return false;
	return true;
      }

    } /* Namespace Type */
  } /* Namespace Base */
} /* Namespace OpenTURNS */
