//                                               -*- C++ -*-
/**
 *  @file  FORMRESULT.hxx
 *  @brief FORMRESULT implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2007-12-27 12:24:11 +0100 (jeu, 27 déc 2007) $
 *  Id:      $Id: FORMRESULT.hxx 714 2007-12-27 11:24:11Z lebrun $
 */
#ifndef OPENTURNS_FORMRESULT_HXX
#define OPENTURNS_FORMRESULT_HXX

#include "AnalyticalResult.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

	/**
	 * @class FORMResult
	 * FORMResult stores the FORM result 
	 */
	class FORMResult:
	  public AnalyticalResult
	{
	  CLASSNAME;
	public:

	  typedef AnalyticalResult::Graph           Graph;
	  typedef AnalyticalResult::GraphCollection GraphCollection;
          typedef AnalyticalResult::StorageManager  StorageManager;
          typedef AnalyticalResult::Sensitivity     Sensitivity;

	  /** Standard constructor */
	  FORMResult(const NumericalPoint & standardSpaceDesignPoint,
		     const Event & limitStateVariable,
		     const Bool isStandardPointOriginInFailureSpace,
		     const String & name = OT::DefaultName);

	  /* Default constructor (required by SWIG :-<) */
	  explicit FORMResult();

	  /** Virtual constructor */
	  virtual FORMResult * clone() const;

	  /** EventProbability accessor */
	  NumericalScalar getEventProbability() const;

	  /** GeneralisedReliabilityIndex accessor */
	  NumericalScalar getGeneralisedReliabilityIndex() const;

	  /** EventProbabilitySensitivity accessor */
	  Sensitivity getEventProbabilitySensitivity();

	  /** HasoferReliabilityIndexSensitivitygraph */
	  GraphCollection drawEventProbabilitySensitivity(NumericalScalar width = DefaultWidth);

	  /** String converter */
	  String str() const;

	  /** Method save() stores the object through the StorageManager */
	  void save(const StorageManager::Advocate & adv) const;

	  /** Method load() reloads the object from the StorageManager */
	  void load(const StorageManager::Advocate & adv);

	private:

	  /** The function that actually evaluates the event probability with FORM approximation */
	  void computeEventProbability();

	  /** The function that actually evaluates the generalised reliability index with FORM approximation */
	  void computeGeneralisedReliabilityIndex();

	  /** The function that actually evaluates the  event probability sensitivity with FORM approximation */
	  void computeEventProbabilitySensitivity();

	  /** EventProbability accessor */
	  void setEventProbability(const NumericalScalar & eventProbability);

	  /** GeneralisedReliabilityIndex accessor */
	  void setGeneralisedReliabilityIndex(const NumericalScalar & generalisedReliabilityIndex);

	  /** EventProbabilitySensitivity accessor */
	  void setEventProbabilitySensitivity(const Sensitivity & eventProbabilitySensitivity);

	  NumericalScalar eventProbability_;
	  NumericalScalar generalisedReliabilityIndex_;
	  Sensitivity eventProbabilitySensitivity_;
	  Bool isAlreadyComputedEventProbabilitySensitivity_;

	}; // class FORMResult

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FORMRESULT_HXX */



