//                                               -*- C++ -*-
/**
 *  @file  Box.hxx
 *  @brief Box experiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: Box.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_BOX_HXX
#define OPENTURNS_BOX_HXX

#include "ExperimentImplementation.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class Box
       *
       * The class describes the probabilistic concept of box experiment plan
       */
      class Box
	: public ExperimentImplementation
      {
	CLASSNAME;
      public:

	typedef ExperimentImplementation::NumericalPoint  NumericalPoint;
	typedef ExperimentImplementation::NumericalSample NumericalSample;
	typedef Base::Common::InvalidArgumentException    InvalidArgumentException;

	/** Default constructor */
	explicit Box(const String & name = OT::DefaultName);

	/** Constructor with parameters */
	explicit Box(const NumericalPoint & center,
		     const NumericalPoint & levels,
		     const String & name = OT::DefaultName)
	  throw(InvalidArgumentException);

	/** Constructor with parameters */
	explicit Box(const NumericalPoint & levels,
		     const String & name = OT::DefaultName)
	  throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual Box * clone() const;

	/** Experiment plane generation :
         *  The box [center - 1/2, center + 1/2] is uniformly sampled in each dimension
         */
	virtual NumericalSample generate();

	/** String converter */
	virtual String str() const;

	/** Specific levels accessor */
	void setLevels(const NumericalPoint & levels) throw(InvalidArgumentException);

      }; /* class Box */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BOX_HXX */
