//                                               -*- C++ -*-
/**
 *  @file  Experiment.cxx
 *  @brief Abstract top-level view of an experiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: Experiment.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "Experiment.hxx"
#include "Axial.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      CLASSNAMEINIT(Experiment);

      /* Default constructor */
      Experiment::Experiment(const String & name)
	: Base::Common::TypedInterfaceObject<ExperimentImplementation>(new Axial(name))
      {
	// Nothing to do
      }

      /* Constructor from implementation pointer */
      Experiment::Experiment(const Implementation & p_implementation,
                             const String & name)
	: Base::Common::TypedInterfaceObject<ExperimentImplementation>(p_implementation)
      {
	// Nothing to do
      }

      /* Constructor from implementation */
      Experiment::Experiment(const ExperimentImplementation & implementation,
                             const String & name)
	: Base::Common::TypedInterfaceObject<ExperimentImplementation>(implementation.clone())
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      Experiment::Experiment(const NumericalPoint & center,
                             const NumericalPoint & levels,
                             const String & name)
	: Base::Common::TypedInterfaceObject<ExperimentImplementation>(new Axial(center, levels, name))
      {
	// Nothing to do
      }

      /* String converter */
      String Experiment::str() const
      {
	OSS oss;
	oss << "class=" << GetClassName()
	    << " name=" << getName ()
	    << " implementation=" << getImplementation()->str();
	return oss;
      }

      /* Center accessor */
      void Experiment::setCenter(const NumericalPoint & center)
      {
	getImplementation()->setCenter(center);
      }

      /* Center accessor */
      Experiment::NumericalPoint Experiment::getCenter() const
      {
	return getImplementation()->getCenter();
      }

      /* Levels accessor */
      void Experiment::setLevels(const NumericalPoint & levels)
      {
	getImplementation()->setLevels(levels);
      }

      /* Levels accessor */
      Experiment::NumericalPoint Experiment::getLevels() const
      {
	return getImplementation()->getLevels();
      }

      void Experiment::setImplementation(const Implementation & p_implementation)
      {
	getImplementation() = p_implementation;
      }

      /* Sample generation */
      Experiment::NumericalSample Experiment::generate()
      {
	return getImplementation()->generate();
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
