//                                               -*- C++ -*-
/**
 *  @file  OrthogonalDirection.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: OrthogonalDirection.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALDIRECTION_HXX
#define OPENTURNS_ORTHOGONALDIRECTION_HXX

#include "SamplingStrategyImplementation.hxx"
#include "Indices.hxx"
#include "Matrix.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalDirection
       */

      class OrthogonalDirection :
	public SamplingStrategyImplementation
      {

	CLASSNAME;

      public:

	typedef SamplingStrategyImplementation::NumericalSample NumericalSample;
	typedef Base::Type::Indices                             Indices;
	typedef Base::Type::Matrix                              Matrix;

	/** Default constructor */
	explicit OrthogonalDirection();

	/** Constructor with parameters */
	OrthogonalDirection(const UnsignedLong dimension,
			    const UnsignedLong size);


	/** Virtual constructor */
	virtual OrthogonalDirection * clone() const;
	
	/** Generate a set of directions */
	NumericalSample generate() const;

	/** String converter */
	String str() const;

	/** Generate a random realization of an orientation matrix in SO(dimension) uniformly distributed relatively to the Haar mesure of SO(dimension) */
	Matrix getUniformOrientationRealization() const;

      private:

	/** Generate the next permutation of indices in-place in the size_ first elements */
	void nextCombination(Indices & indices) const;

	/** Add the 2^size linear combinations of columns of Q indicated in the
	 * size first elements of indices by affecting all the choices of sign
	 * to the coefficients of the linear combination */
	void computePartialSample(const Indices & indices,
				  const Matrix & Q,
				  NumericalSample & result) const;
	/** Size of the direction subset */
	UnsignedLong size_;

      } ; /* class OrthogonalDirection */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALDIRECTION_HXX */
