//                                               -*- C++ -*-
/**
 *  @file  RandomDirection.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: RandomDirection.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "RandomDirection.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class RandomDirection
       */

      CLASSNAMEINIT(RandomDirection);

      /* Default constructor */
      RandomDirection::RandomDirection():
	SamplingStrategyImplementation(0)
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      RandomDirection::RandomDirection(const UnsignedLong dimension):
	SamplingStrategyImplementation(dimension)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      RandomDirection * RandomDirection::clone() const
      {
	return new RandomDirection(*this);
      }

      /* Generate a set of directions */
      RandomDirection::NumericalSample RandomDirection::generate() const
      {
	NumericalSample result(2, dimension_);
	result[0] = getUniformUnitVectorRealization();
	result[1] = -1.0 * result[0];
	return result;
      }

      /* String converter */
      String RandomDirection::str() const
      {
	OSS oss;
	oss << "class=" << RandomDirection::GetClassName()
	    << " derived from " << SamplingStrategyImplementation::str();
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

