//                                               -*- C++ -*-
/**
 *  @file  RootStrategy.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: RootStrategy.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_ROOTSTRATEGY_HXX
#define OPENTURNS_ROOTSTRATEGY_HXX

#include "RootStrategyImplementation.hxx"
#include "Pointer.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class RootStrategy
       */

      class RootStrategy
	: public Base::Common::TypedInterfaceObject<RootStrategyImplementation>
      {
	CLASSNAME;

      public:
	typedef Base::Common::Pointer<RootStrategyImplementation>     Implementation;
	typedef RootStrategyImplementation::NumericalScalarCollection NumericalScalarCollection;
	typedef RootStrategyImplementation::Solver                    Solver;
	typedef RootStrategyImplementation::NumericalMathFunction     NumericalMathFunction;
	typedef RootStrategyImplementation::InvalidArgumentException  InvalidArgumentException;
	typedef RootStrategyImplementation::InternalException         InternalException;
	typedef RootStrategyImplementation::InvalidDimensionException InvalidDimensionException;
	typedef RootStrategyImplementation::NotDefinedException       NotDefinedException;

	/** Constructor with parameters */
	RootStrategy(const RootStrategyImplementation & implementation);

	/** Constructor with parameters */
	RootStrategy(Implementation & p_implementation);

	/** Default Constructor: choose the SafeAndSlow strategy with its default solver */
	explicit RootStrategy();


	/** Solve gives all the roots found applying the root strategy */
	NumericalScalarCollection solve(const NumericalMathFunction & function,
					const NumericalScalar value);

	/** Solver accessor */
	void setSolver(const Solver & solver);
	Solver getSolver() const;

	/** Maximum distance accessor */
	void setMaximumDistance(const NumericalScalar maximumDistance)
          throw(InvalidArgumentException);
	NumericalScalar getMaximumDistance() const;

	/** Step size accessor */
	void setStepSize(const NumericalScalar stepSize) throw(InvalidArgumentException);
	NumericalScalar getStepSize() const;

	/** Value of the performance function at the origin accessor */
	void setOriginValue(const NumericalScalar originValue);
	NumericalScalar getOriginValue() const throw(NotDefinedException);

	/** String converter */
	String str() const;

      } ; /* class RootStrategy */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ROOTSTRATEGY_HXX */
