//                                               -*- C++ -*-
/**
 *  @file  LogNormal.hxx
 *  @brief The LogNormal distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: LogNormal.hxx 929 2008-09-13 20:37:56Z dutka $
 */
#ifndef OPENTURNS_LOGNORMAL_HXX
#define OPENTURNS_LOGNORMAL_HXX

#include "OT.hxx"
#include "NonEllipticalDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {


      /**
       * @class LogNormal
       *
       * The LogNormal distribution.
       */
      class LogNormal 
	: public Model::NonEllipticalDistribution
      {
	CLASSNAME;
      public:

	typedef Base::Common::InvalidArgumentException               InvalidArgumentException;
	typedef Model::NonEllipticalDistribution                     NonEllipticalDistribution;  // required by SWIG
	typedef NonEllipticalDistribution::NumericalPoint            NumericalPoint;
	typedef NonEllipticalDistribution::NumericalSample           NumericalSample;
	typedef NonEllipticalDistribution::CovarianceMatrix          CovarianceMatrix;
	typedef NonEllipticalDistribution::NumericalPointWithDescriptionCollection  NumericalPointWithDescriptionCollection;
	typedef NonEllipticalDistribution::NotDefinedException       NotDefinedException;
	typedef NonEllipticalDistribution::StorageManager            StorageManager;

	enum ParameterSet { MUSIGMA_LOG, MUSIGMA, MU_SIGMAOVERMU };

	/** Default constructor */
        LogNormal();

	/** Parameters constructor */
        LogNormal(const NumericalScalar arg1,
		  const NumericalScalar arg2,
		  const NumericalScalar gamma = 0.0,
		  const ParameterSet set = MUSIGMA_LOG)
	  throw (InvalidArgumentException);


	/** Comparison operator */
	Bool operator ==(const LogNormal & other) const;

	/** String converter */
	String str() const;



	/* Interface inherited from Distribution */

	/** Virtual constructor */
	virtual LogNormal * clone() const;

	/** Get one realization of the LogNormal distribution */
	virtual NumericalPoint getRealization() const;

	/** Get the DDF of the LogNormal distribution */
	using NonEllipticalDistribution::computeDDF;
	virtual NumericalPoint computeDDF(const NumericalPoint & point) const;

	/** Get the PDF of the LogNormal distribution */
	using NonEllipticalDistribution::computePDF;
	virtual NumericalScalar computePDF(const NumericalPoint & point) const;

	/** Get the CDF of the LogNormal distribution */
	using NonEllipticalDistribution::computeCDF;
	virtual NumericalScalar computeCDF(const NumericalPoint & point, const Bool tail = false) const;

	/** Get the PDFGradient of the LogNormal distribution */
	virtual NumericalPoint computePDFGradient(const NumericalPoint & point) const;

	/** Get the CDFGradient of the LogNormal distribution */
	virtual NumericalPoint computeCDFGradient(const NumericalPoint & point) const;

	/** Get the quantile of the LogNormal distribution */
	virtual NumericalPoint computeQuantile(const NumericalScalar prob) const;
	
	/** Get the mean of the distribution */
	virtual NumericalPoint getMean() const throw(NotDefinedException);

	/** Get the standard deviation of the distribution */
	virtual NumericalPoint getStandardDeviation() const throw(NotDefinedException);

	/** Get the skewness of the distribution */
	virtual NumericalPoint getSkewness() const throw(NotDefinedException);

	/** Get the kurtosis of the distribution */
	virtual NumericalPoint getKurtosis() const throw(NotDefinedException);

	/** Get the covariance of the distribution */
	virtual CovarianceMatrix getCovariance() const throw(NotDefinedException);

	/** Parameters value and description accessor */
	virtual NumericalPointWithDescriptionCollection getParametersCollection() const;

	/* Interface specific to LogNormal */

	/** MuLog accessor */
	void setMuLog(const NumericalScalar muLog);
	NumericalScalar getMuLog() const;

	/** SigmaLog accessor */
	void setSigmaLog(const NumericalScalar sigmaLog)
	  throw (InvalidArgumentException);
	NumericalScalar getSigmaLog() const;


	/** Mu accessor */
	void setMuSigma(const NumericalScalar mu,
                        const NumericalScalar sigma)
	  throw (InvalidArgumentException);
	NumericalScalar getMu() const;

	/** Sigma accessor */
	NumericalScalar getSigma() const;

	/** Gamma accessor */
	void setGamma(const NumericalScalar gamma);
	NumericalScalar getGamma() const;

	/** SigmaOverMu accessor */
	NumericalScalar getSigmaOverMu() const throw(NotDefinedException);

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);

      protected:
    
    
      private:

	/** Compute the numerical range of the distribution given the parameters values */
	void computeRange();

	/** The main parameter set of the distribution */
	NumericalScalar muLog_;
	NumericalScalar sigmaLog_;
	NumericalScalar gamma_;
	NumericalScalar normalizationFactor_;

      }; /* class LogNormal */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOGNORMAL_HXX */
