//                                               -*- C++ -*-
/**
 *  @file  LogisticFactory.cxx
 *  @brief Factory for Logistic distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu 10 mai 2007) $
 *  Id:      $Id: LogisticFactory.cxx 434 2007-05-10 14:43:31Z dutka $
 */
#include "LogisticFactory.hxx"
#include "Logistic.hxx"
#include "SpecFunc.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef Model::DistributionImplementationFactory::NumericalPoint NumericalPoint;

      /* Default constructor */
      LogisticFactory::LogisticFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      LogisticFactory * LogisticFactory::clone() const
      {
	return new LogisticFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      LogisticFactory::DistributionImplementation * LogisticFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a Logistic distribution from an empty sample";
	if (sample.getDimension() != 1) throw InvalidArgumentException(HERE) << "Error: can build a Logistic distribution only from a sample of dimension 1, here dimension=" << sample.getDimension();
	NumericalScalar alpha(sample.computeMean()[0]);
	NumericalScalar beta(sample.computeStandardDeviationPerComponent()[0] * SpecFunc::SQRT3_PI);
	if (beta <= 0.0) throw InternalException(HERE) << "Error: can build a Logistic distribution only if beta > 0.0, here beta=" << beta;
	return Logistic(alpha, beta).clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
