//                                               -*- C++ -*-
/**
 *  @file  NormalFactory.cxx
 *  @brief Factory for Normal distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: NormalFactory.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <cmath>
#include "NormalFactory.hxx"
#include "Normal.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef Normal::NumericalPoint    NumericalPoint;
      typedef Normal::CorrelationMatrix CorrelationMatrix;
      typedef Normal::CovarianceMatrix  CovarianceMatrix;

      /* Default constructor */
      NormalFactory::NormalFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      NormalFactory * NormalFactory::clone() const
      {
	return new NormalFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      NormalFactory::DistributionImplementation * NormalFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a Normal distribution from an empty sample";
	const NumericalPoint mean(sample.computeMean());
	const CovarianceMatrix covariance(sample.computeCovariance());
	if (!covariance.isPositiveDefinite()) throw InternalException(HERE) << "Error: can build a Normal distribution only from a sample with a positive definite covariance matrix, here covariance=" << covariance;
	return Normal(mean, covariance).clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
