//                                               -*- C++ -*-
/**
 *  @file  CompositeRandomVector.hxx
 *  @brief An implementation class for composite random vectors
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: CompositeRandomVector.hxx 815 2008-05-21 09:21:38Z dutka $
 */
#ifndef OPENTURNS_COMPOSITERANDOMVECTOR_HXX
#define OPENTURNS_COMPOSITERANDOMVECTOR_HXX

#include "RandomVectorImplementation.hxx"
#include "Pointer.hxx"
#include "NumericalMathFunction.hxx"
#include "CovarianceMatrix.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {



      /**
       * @class CompositeRandomVector
       *
       * An implementation class for composite random vectors
       */
      class CompositeRandomVector 
	: public RandomVectorImplementation
      {
	CLASSNAME;

      public:

	/** Some typedefs to ease reading */
	typedef RandomVectorImplementation::Antecedent               Antecedent;
	typedef RandomVectorImplementation::NumericalPoint           NumericalPoint;
	typedef RandomVectorImplementation::NumericalSample          NumericalSample;
	typedef RandomVectorImplementation::CovarianceMatrix         CovarianceMatrix;
	typedef RandomVectorImplementation::NumericalMathFunction    NumericalMathFunction;
	typedef RandomVectorImplementation::StorageManager           StorageManager;
	typedef RandomVectorImplementation::InvalidArgumentException InvalidArgumentException;

	/** Standard constructor */
	CompositeRandomVector(const NumericalMathFunction & function,
			      const Antecedent & p_antecedent,
			      const String & name = OT::DefaultName)
	  throw (InvalidArgumentException);


	/** Virtual constructor */
	CompositeRandomVector * clone() const;

	/** String converter */
	String str() const;



	/** Is the underlying random vector composite ? */
	Bool isComposite() const;


	/* Here is the interface that all derived class must implement */

	/** Dimension accessor */
	UnsignedLong getDimension() const;

	/** Realization accessor */
	NumericalPoint getRealization() const;

	/** Numerical sample accessor */
	NumericalSample getNumericalSample(const UnsignedLong size) const;

	/** Mean accessor */
	NumericalPoint getMean() const;

	/** Covariance accessor */
	CovarianceMatrix getCovariance() const;

	/** Get the random vector corresponding to the i-th marginal component */
	Implementation getMarginal(const UnsignedLong i) const throw(InvalidArgumentException);

	/** Get the marginal random vector corresponding to indices components */
	Implementation getMarginal(const Indices & indices) const throw(InvalidArgumentException);

	/** Antecedent accessor */
	Antecedent getAntecedent() const;

	/** Function accessor */
	NumericalMathFunction getFunction() const;

	/** Distribution accessor */
	Distribution getDistribution() const;

	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);	

      protected:

	friend class Base::Common::Factory<CompositeRandomVector>;

	/** Default constructor */
	CompositeRandomVector(const String & name = OT::DefaultName) : RandomVectorImplementation(name) {};
    
	/** The function the vector is the output */
	NumericalMathFunction function_;
    
	/** The antecedent of the vector through the numerical math function */
	Antecedent p_antecedent_;
    
      private:

      }; /* class CompositeRandomVector */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPOSITERANDOMVECTOR_HXX */
