//                                               -*- C++ -*-
/**
 * @file  DistributionFactory.cxx
 * @brief Top-level class for all distribution factories
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 */

#include "DistributionFactory.hxx"
#include "Description.hxx"
#include "Path.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(DistributionFactory);

      /* Default constructor */
      DistributionFactory::DistributionFactory(const String & name)
	: Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(new DistributionImplementationFactory(name))
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Parameter constructor */
      DistributionFactory::DistributionFactory(const DistributionImplementationFactory & factory)
	: Base::Common::TypedInterfaceObject<DistributionImplementationFactory>(factory.clone())
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* String converter */
      String DistributionFactory::str() const {
	OSS oss;
	oss << "class=" << DistributionFactory::GetClassName()
	    << " implementation=" << getImplementation()->str();
	return oss;
      }

      /* Here is the interface that all derived class must implement */
      Distribution DistributionFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	return getImplementation()->buildImplementation(sample);
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
