//                                               -*- C++ -*-
/**
 *  @file  UsualDistribution.cxx
 *  @brief Abstract top-level class for all standard distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: UsualDistribution.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(UsualDistribution);

      /* Default constructor */
      UsualDistribution::UsualDistribution(const String & name)
	: DistributionImplementation(name)
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Destructor */
      UsualDistribution::~UsualDistribution() {
	// Remember to free any allocated memory space
	// Remember NOT to throw any exception here
      }

      /* Comparison operator */
      Bool UsualDistribution::operator ==(const UsualDistribution & other) const {
	Bool sameObject = false;

	if (this != &other) { // Other is NOT me, so I have to realize the comparison
	  // sameObject = ...
	} else sameObject = true;

	return sameObject;
      }
  
      /* String converter */
      String UsualDistribution::str() const {
	OSS oss;
	oss << "class=" << UsualDistribution::GetClassName();
	return oss;
      }
  
      /* Tell if the distribution is elliptical */
      Bool UsualDistribution::isElliptical() const
      {
	return false;
      }
    
      /* Tell if the distribution is continuous */
      Bool UsualDistribution::isContinuous() const
      {
	return false;
      }
    


      
    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
