//                                               -*- C++ -*-
/**
 *  @file  UsualDistribution.hxx
 *  @brief Abstract top-level class for all standard distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: UsualDistribution.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_USUALDISTRIBUTION_HXX
#define OPENTURNS_USUALDISTRIBUTION_HXX

#include "OT.hxx"
#include "DistributionImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class UsualDistribution
       *
       * All traditionnal distribution inherits from this class.
       * Classes derived from UsualDistribution are known by themselves,
       * without being reconstructed or built in any way.
       */
      class UsualDistribution 
	: public DistributionImplementation
      {
	CLASSNAME;
      public:

	typedef DistributionImplementation::Implementation            Implementation;
	typedef DistributionImplementation::InvalidArgumentException  InvalidArgumentException;
	typedef DistributionImplementation::InvalidDimensionException InvalidDimensionException;
	typedef DistributionImplementation::InternalException         InternalException;
	typedef DistributionImplementation::NotDefinedException       NotDefinedException;
	typedef DistributionImplementation::NumericalPoint            NumericalPoint;
	typedef DistributionImplementation::NumericalSample           NumericalSample;
	typedef DistributionImplementation::CovarianceMatrix          CovarianceMatrix;
	typedef DistributionImplementation::Indices                   Indices;
	typedef DistributionImplementation::IsoProbabilisticTransformation        IsoProbabilisticTransformation;
	typedef DistributionImplementation::InverseIsoProbabilisticTransformation InverseIsoProbabilisticTransformation;
	typedef DistributionImplementation::NumericalPointCollection  NumericalPointCollection;
	typedef DistributionImplementation::NumericalPointWithDescriptionCollection  NumericalPointWithDescriptionCollection;

	/** Default constructor */
	explicit UsualDistribution(const String & name = OT::DefaultName);


	/** Destructor */
	virtual ~UsualDistribution();

	/** Virtual constructor */
	virtual DistributionImplementation * clone() const = 0;

	/** Comparison operator */
	Bool operator ==(const UsualDistribution & other) const;

	/** String converter */
	String str() const;



	/* Here is the interface that all derived class must implement */

	/** Tell if the distribution is elliptical */
	virtual Bool isElliptical() const;

	/** Tell if the distribution is continuous */
	virtual Bool isContinuous() const;



      protected:
    
    
      private:

      }; /* class UsualDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_USUALDISTRIBUTION_HXX */
