//                                               -*- C++ -*-
/**
 *  @file  LinearModelTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: LinearModelTest.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_LINEARMODELTEST_HXX
#define OPENTURNS_LINEARMODELTEST_HXX

#include "OT.hxx"
#include "Exception.hxx"
#include "TestResult.hxx"
#include "NumericalSample.hxx"
#include "LinearModel.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace StatTest
    {

      /**
       * @class LinearModelTest
       *
       */

      class LinearModelTest
      {
      public:

        typedef Base::Common::InternalException         InternalException;
	typedef Base::Stat::TestResult                  TestResult;
	typedef Base::Stat::NumericalSample             NumericalSample;
	typedef Base::Stat::LinearModel                 LinearModel;

	/** Default constructor */
	LinearModelTest();

	/**  */
	static TestResult LMAdjustedRSquared(const NumericalSample & firstSample,
					     const NumericalSample & secondSample,
					     const LinearModel & linearModel,
					     const NumericalScalar level=0.95);

	/**  */
	static TestResult LMAdjustedRSquared(const NumericalSample & firstSample,
					     const NumericalSample & secondSample,
					     const NumericalScalar level=0.95);

	/**  */
	static TestResult LMFisher(const NumericalSample & firstSample,
				   const NumericalSample & secondSample,
				   const LinearModel & linearModel,
				   const NumericalScalar level=0.95);

	/**  */
	static TestResult LMFisher(const NumericalSample & firstSample,
				   const NumericalSample & secondSample,
				   const NumericalScalar level=0.95);

	/**  */
	static TestResult LMResidualMean(const NumericalSample & firstSample,
					 const NumericalSample & secondSample,
					 const LinearModel & linearModel,
					 const NumericalScalar level=0.95);

	/**  */
	static TestResult LMResidualMean(const NumericalSample & firstSample,
					 const NumericalSample & secondSample,
					 const NumericalScalar level=0.95);

	/**  */
	static TestResult LMRSquared(const NumericalSample & firstSample,
				     const NumericalSample & secondSample,
				     const LinearModel & linearModel,
				     const NumericalScalar level=0.95);

	/**  */
	static TestResult LMRSquared(const NumericalSample & firstSample,
				     const NumericalSample & secondSample,
				     const NumericalScalar level=0.95);

      protected:
	/** Generic invocation of a R script for testing a distribution against a sample */
	static TestResult RunTwoSamplesALinearModelRTest(const NumericalSample & firstSample,
							 const NumericalSample & secondSample,
							 const LinearModel & linearModel,
							 const NumericalScalar level,
							 const String & testName)
	  throw(InternalException);

      }; /* class LinearModelTest */

    } /* namespace StatTest */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_LINEARMODELTEST_HXX */
