//                                               -*- C++ -*-
/**
 *  @file  TestOptimLinear.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-08-01 16:47:51 +0200 (mer 01 aoû 2007) $
 *  Id:      $Id: TestOptimLinear.cxx 488 2007-08-01 14:47:51Z dutka $
 */
#include <iostream>
#include <cstdlib>
#include "OT.hxx"
#include "WrapperInterface.h"

namespace WrapperInternals {
  struct internalState {
    long numberOfCalls;
  };

  void internalStateInitialization(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls = 0;
  }

  void internalStateIncrement(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls++;
  }

  long internalStateGetNumberOfCalls(struct internalState * p_internalState)
  {
    return (p_internalState ? p_internalState->numberOfCalls : -1);
  }
} /* namespace WrapperInternals */

extern "C" {
  /* Function */
  enum WrapperErrorCode func_createState_optim_linear(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_deleteState_optim_linear(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  static struct WrapperInformation info_optim_linear = {/* inSize_  = */ 4,
							/* outSize_ = */ 1};

  enum WrapperErrorCode func_getInfo_optim_linear(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_optim_linear;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_init_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_optim_linear(void * p_state, const struct point * inPoint, struct point * outPoint)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    double x1(inPoint->data_[0]);
    double x2(inPoint->data_[1]);
    double x3(inPoint->data_[2]);
    double x4(inPoint->data_[3]);

    outPoint->data_[0] = x1+2*x2-3*x3+4*x4;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_sample_optim_linear(void * p_state, const struct sample * inSample, struct sample * outSample)
  {
    unsigned long inDimension((inSample->data_[0]).size_);
    if (info_optim_linear.inSize_ != inDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long outDimension((outSample->data_[0]).size_);
    if (info_optim_linear.outSize_ != outDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long size(inSample->size_);
    for (unsigned long i = 0; i < size; i++)
      {
        if (func_exec_optim_linear(p_state, &(inSample->data_[i]),  &(outSample->data_[i])) != WRAPPER_OK) return WRAPPER_EXECUTION_ERROR;
      }
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_finalize_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Gradient, which is void at this time */
  enum WrapperErrorCode grad_createState_optim_linear(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_deleteState_optim_linear(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_getInfo_optim_linear(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_optim_linear;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_init_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_exec_optim_linear(void * p_state, const struct point * inPoint, struct matrix * outMatrix)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_finalize_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Hessian, which is void at this time */
  enum WrapperErrorCode hess_createState_optim_linear(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_deleteState_optim_linear(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_getInfo_optim_linear(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_optim_linear;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_init_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_exec_optim_linear(void * p_state, const struct point * inPoint, struct tensor * outTensor)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_finalize_optim_linear(void * p_state)
  {
    return WRAPPER_OK;
  }
} /* end extern "C" */
