//                                               -*- C++ -*-
/**
 *  @file  t_Cache_std.cxx
 *  @brief The test file of class Cache for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-22 11:34:11 +0200 (lun 22 sep 2008) $
 *  Id:      $Id: t_Cache_std.cxx 941 2008-09-22 09:34:11Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Cache.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    // Create a Cache object
    Cache myCache(3);
    myCache.setName("aCache");
    myCache.enable();

    std::cout << "myCache = " << myCache << std::endl;

    // Create a point and add it to the cache
    NumericalPoint k(3);
    k[0] = 1.;
    k[1] = 2.;
    k[2] = 3.;
    NumericalPoint v(2);
    v[0] = 10.;
    v[1] = 20.;
    myCache.add( k, v );

    std::cout << "myCache = " << myCache << std::endl;

    // Create a fake point
    NumericalPoint ko(3);
    ko[0] = -1.;
    ko[1] = -2.;
    ko[2] = -3.;

    // Create a valid point
    NumericalPoint ok(k);

    // Check which point is in the cache and retrieve corresponding values
    std::cout << "Is ko in myCache ? " << myCache.hasKey( ko ) << std::endl;
    std::cout << "Cache value for ko = " << myCache.find( ko ) << std::endl;

    std::cout << "Is ok in myCache ? " << myCache.hasKey( ok ) << std::endl;
    std::cout << "Cache value for ok = " << myCache.find( ok ) << std::endl;

    std::cout << "myCache = " << myCache << std::endl;

    // Add some more points in the cache
    NumericalPoint p1  = 2. * k;
    NumericalPoint pv1 = 2. * v;
    myCache.add( p1, pv1 );
    std::cout << "myCache = " << myCache << std::endl;

    NumericalPoint p2  = 3. * k;
    NumericalPoint pv2 = 3. * v;
    myCache.add( p2, pv2 );
    std::cout << "myCache = " << myCache << std::endl;

    NumericalPoint p3  = 4. * k;
    NumericalPoint pv3 = 4. * v;
    myCache.add( p3, pv3 );
    std::cout << "myCache = " << myCache << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
