//                                               -*- C++ -*-
/**
 *  @file  t_CenteredFiniteDifferenceGradient_std.cxx
 *  @brief The test file of class CenteredFiniteDifferenceGradient for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu 10 mai 2007) $
 *  Id:      $Id: t_CenteredFiniteDifferenceGradient_std.cxx 434 2007-05-10 14:43:31Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "CenteredFiniteDifferenceGradient.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Diff;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    NumericalScalar eps(1e-2);
    /** Instance creation */
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalPoint epsilon(myFunc.getInputNumericalPointDimension(), eps);
    NumericalPoint in(epsilon.getDimension(), 1.0);
    CenteredFiniteDifferenceGradient myGradient(epsilon, myFunc.getEvaluationImplementation());

    std::cout << "myGradient=" << myGradient << std::endl;
    std::cout << "myFunc.gradient(" << in << ")=" << myFunc.gradient(in) << std::endl;
    std::cout << "myGradient.gradient(" << in << ")=" << myGradient.gradient(in) << std::endl;
    /** Substitute the gradient */
    myFunc.setGradientImplementation(new CenteredFiniteDifferenceGradient(myGradient));
    std::cout << "myFunc.gradient(" << in << ")=" << myFunc.gradient(in) << " (after substitution)" << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
