//                                               -*- C++ -*-
/**
 *  @file  t_Cobyla_linear.cxx
 *  @brief The test file of class Cobyla for solving a linear problem
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-08-01 16:47:51 +0200 (mer 01 aoû 2007) $
 *  Id:      $Id: t_Cobyla_linear.cxx 488 2007-08-01 14:47:51Z dutka $
 */
#include <iostream>
#include <cmath>
#include <sstream>
#include <iomanip>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "Cobyla.hxx"
#include "NearestPointAlgorithm.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Optimisation;

String printNumericalPoint(const NumericalPoint & point, const UnsignedLong digits)
{
  OSS oss;
  oss << "[";
  NumericalScalar eps(pow(0.1, digits));
  for (UnsignedLong i = 0; i < point.getDimension(); i++)
    {
      oss << std::fixed << std::setprecision(digits) << (i==0 ? "" : ",") << Bulk<double>((fabs(point[i]) < eps) ? fabs(point[i]) : point[i]);
    }
  oss << "]";
  return oss;  
}

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    try {
      // Test function operator ()
      NumericalMathFunction levelFunction("TestOptimLinear");
      Cobyla::SpecificParameters specific;
      NumericalPoint startingPoint(4, 0.0);
      Cobyla myAlgorithm(specific, levelFunction);
      myAlgorithm.setStartingPoint(startingPoint);
      myAlgorithm.setLevelValue(3.0);
      std::cout << "myAlgorithm = " << myAlgorithm << std::endl;
      myAlgorithm.run();
      std::cout << "result = " << printNumericalPoint(myAlgorithm.getResult().getMinimizer(), 4) << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.str());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
