//                                               -*- C++ -*-
/**
 *  @file  t_Collection_std.cxx
 *  @brief The test file of class Collection for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_Collection_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  /* Default constructor */
  Collection<double> point1;

  /* Check method add() */
  point1.add(0.);
  point1.add(1.);

  std::cout << "size of point1 = " << point1.getSize() << std::endl;

  std::cout << "point1[0] = " << point1[0] << std::endl
	    << "point1[1] = " << point1[1] << std::endl;


  /* Constructor with size */
  Collection<double> point2(2);

  /* Check operator[] methods */
  point2[0] = 10.;
  point2[1] = 11.;

  std::cout << "point2[0] = " << point2[0] << std::endl
	    << "point2[1] = " << point2[1] << std::endl;


  /* Copy constructor */
  Collection<double> point3(point1);

  std::cout << "point3[0] = " << point3[0] << std::endl
	    << "point3[1] = " << point3[1] << std::endl;


  /* Assignment operator */
  Collection<double> point4;
  point4 = point2;

  std::cout << "point4[0] = " << point4[0] << std::endl
	    << "point4[1] = " << point4[1] << std::endl;

  /* Stream operator */
  std::cout << "point1 = " << point1 << std::endl;

  /* Constructor with size and value */
  Collection<double> point5(5, 1.0);
  std::cout << "point5 = " << point5 << std::endl;


  return ExitCode::Success;
}
