//                                               -*- C++ -*-
/**
 * @file  t_ComputedNumericalMathEvaluationImplementation_state.cxx
 * @brief The test file of class ComputedNumericalMathEvaluationImplementation with two different internal states
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_ComputedNumericalMathEvaluationImplementation_state.cxx 862 2008-06-26 11:50:17Z dutka $
 */

#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "ComputedNumericalMathEvaluationImplementationFactory.hxx"
#include "ComputedNumericalMathEvaluationImplementation.hxx"
#include "Exception.hxx"

using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    try {
      /** Instance creation */
      ComputedNumericalMathEvaluationImplementationFactory::Instance instance = ComputedNumericalMathEvaluationImplementationFactory::getInstance();
      
      // Test function operator ()
      // ComputedNumericalMathEvaluationImplementation myFunction("wrapper");
      ComputedNumericalMathEvaluationImplementationFactory::Implementation myFunctionImpl = instance->buildImplementation("wrapper");
      NumericalPoint inPoint1(2);
      inPoint1[0] = 10;
      inPoint1[1] = 10;
      NumericalPoint outPoint1 = (*myFunctionImpl)( inPoint1 );
      outPoint1 = (*myFunctionImpl)( inPoint1 );
      std::cout << myFunctionImpl->getName() << "( " << inPoint1 << " ) = " << outPoint1 << std::endl;




      // Now we copy the object
      const ComputedNumericalMathEvaluationImplementation & ref_myFunctionImpl = * static_cast<ComputedNumericalMathEvaluationImplementation*>(myFunctionImpl.get());
      ComputedNumericalMathEvaluationImplementation newFunctionImpl(ref_myFunctionImpl);
      NumericalPoint inPoint2(2);
      inPoint2[0] = 100;
      inPoint2[1] = 100;
      NumericalPoint outPoint2 = newFunctionImpl( inPoint2 );
      outPoint2 = newFunctionImpl( inPoint2 );
      outPoint2 = newFunctionImpl( inPoint2 );
      std::cout << newFunctionImpl.getName() << "( " << inPoint2 << " ) = " << outPoint2 << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.str());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
