//                                               -*- C++ -*-
/**
 *  @file  t_Distributions_draw.cxx
 *  @brief The test file of class Normal for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_Distributions_draw.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <cmath>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "CorrelationMatrix.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  // UnsignedLong pointNumber(251);

  try {
    Normal dist1D(2.0, 4.0);
    Normal dist2D(NumericalPoint(2, 2.0), NumericalPoint(2, 4.0), CorrelationMatrix(2));
    Normal distND(NumericalPoint(5, 2.0), NumericalPoint(5, 4.0), CorrelationMatrix(5));
    // Check drawing methods for 1D distributions
    Graph graphPDF(dist1D.drawPDF());
    graphPDF.draw("DefaultDrawPDF_1D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist1D.drawPDF(-4.0, 4.0, 101);
    graphPDF.draw("FullParametersDrawPDF_1D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist1D.drawPDF(-4.0, 4.0);
    graphPDF.draw("RangeDrawPDF_1D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist1D.drawPDF(101);
    graphPDF.draw("PointNumberDrawPDF_1D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    Graph graphCDF(dist1D.drawCDF());
    graphCDF.draw("DefaultDrawCDF_1D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist1D.drawCDF(-4.0, 4.0, 101);
    graphCDF.draw("FullParametersDrawCDF_1D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist1D.drawCDF(-4.0, 4.0);
    graphCDF.draw("RangeDrawCDF_1D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist1D.drawCDF(101);
    graphCDF.draw("PointNumberDrawCDF_1D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    // Check drawing methods for 2D distributions
    graphPDF = dist2D.drawPDF();
    graphPDF.draw("DefaultDrawPDF_2D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist2D.drawPDF(NumericalPoint(2, -4.0), NumericalPoint(2, 4.0), NumericalPoint(2, 101));
    graphPDF.draw("FullParametersDrawPDF_2D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist2D.drawPDF(NumericalPoint(2, -4.0), NumericalPoint(2, 4.0));
    graphPDF.draw("RangeDrawPDF_2D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = dist2D.drawPDF(NumericalPoint(2, 101));
    graphPDF.draw("PointNumberDrawPDF_2D");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphCDF = dist2D.drawCDF();
    graphCDF.draw("DefaultDrawCDF_2D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist2D.drawCDF(NumericalPoint(2, -4.0), NumericalPoint(2, 4.0), NumericalPoint(2, 101));
    graphCDF.draw("FullParametersDrawCDF_2D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist2D.drawCDF(NumericalPoint(2, -4.0), NumericalPoint(2, 4.0));
    graphCDF.draw("RangeDrawCDF_2D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = dist2D.drawCDF(NumericalPoint(2, 101));
    graphCDF.draw("PointNumberDrawCDF_2D");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    // Check drawing methods for ND distributions
    graphPDF = distND.drawMarginal1DPDF(2, -4.0, 4.0, 101);
    graphPDF.draw("FullParametersDrawMarginal1DPDF_ND");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphPDF = distND.drawMarginal2DPDF(2, 3, NumericalPoint(2, -4.0), NumericalPoint(2, 4.0), NumericalPoint(2, 101));
    graphPDF.draw("FullParametersDrawMarginal2DPDF_ND");
    std::cout << "graphPDF=" << graphPDF.getBitmap() << std::endl;
    graphCDF = distND.drawMarginal1DCDF(2, -4.0, 4.0, 101);
    graphCDF.draw("FullParametersDrawMarginal1DCDF_ND");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
    graphCDF = distND.drawMarginal2DCDF(2, 3, NumericalPoint(2, -4.0), NumericalPoint(2, 4.0), NumericalPoint(2, 101));
    graphCDF.draw("FullParametersDrawMarginal2DCDF_ND");
    std::cout << "graphCDF=" << graphCDF.getBitmap() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
