//                                               -*- C++ -*-
/**
 *  @file  t_LinearModel_std.cxx
 *  @brief The test file of class LinearModel
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_LinearModel_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "LinearModel.hxx"
#include "LinearModelFactory.hxx"
#include "NumericalSample.hxx"
#include "Collection.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();
  
  /** TEST NUMBER ZERO : DEFAULT & COPY CONSTRUCTORs AND STRING CONVERTER */
  std::cout << "test number zero : default & copy constructors and string converter" << std::endl;
  
  NumericalPoint vectR(1, 12.0);
  NumericalSample testSample(1, 1);
  
  NumericalScalar begin(-1.0);
  NumericalScalar end(36.92);
  ConfidenceInterval testInterval(begin, end);
  testInterval.setName("testInterval");
  
  OT::Base::Type::Collection<ConfidenceInterval> coll;
  coll.add(testInterval);
  
  OT::Base::Type::Collection<NumericalScalar> valColl;
  valColl.add(1.0);
  
  /* Default constructor */
  LinearModel LM(vectR, coll, valColl);
  LinearModel LMcopy(LM);
  
  /* Constructor from NumericalPoint */
  LinearModel emptyLM(vectR);
  
  /* String converter */
  std::cout << "LM = " << LM << std::endl;
  std::cout << "LMcopy = " << LMcopy << std::endl;
  std::cout << "emptyLM = " << emptyLM << std::endl;
  
  
  /** TEST NUMBER ONE : GET ELEMENTS */
  std::cout << "test number one : get elements" << std::endl;
  
  std::cout << "LM.getRegression = " << LM.getRegression() << std::endl;
  std::cout << "LM.getConfidenceIntervals = " << LM.getConfidenceIntervals() << std::endl;
  std::cout << "LM.getPValues = " << LM.getPValues() << std::endl;
  
  
  /** TEST NUMBER TWO : GET PREDICT/RESIDUAL */
  std::cout << "test number two : get predicted/residual" << std::endl;
  LinearModelFactory lmfact;
  UnsignedLong size(20);
  NumericalSample oneSample(size, 1);
  NumericalSample twoSample(size, 1);
  for (UnsignedLong i = 0; i < size; ++i)
    {
      oneSample[i][0] = 7.0 * sin(-3.5 + (6.5 * i) / (size - 1.0)) + 2.0;
      twoSample[i][0] = -2.0 * oneSample[i][0] + 3.0 + 0.05 * sin(oneSample[i][0]);
    }
  LinearModel test(lmfact.buildLM(oneSample, twoSample));
  std::cout << "LM.getPredicted = " << test.getPredicted(oneSample) << std::endl;
  std::cout << "LM.getResidual = " << test.getResidual(oneSample, twoSample) << std::endl;
  
  
  return ExitCode::Success;
}
