//                                               -*- C++ -*-
/**
 * @file  t_LinearNumericalMathEvaluationImplementation_std.cxx
 * @brief The test file of class LinearNumericalMathEvaluationImplementation for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_LinearNumericalMathEvaluationImplementation_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */

#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "LinearNumericalMathEvaluationImplementation.hxx"
#include "NumericalPoint.hxx"
#include "NumericalMathFunction.hxx"
#include "Matrix.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    UnsignedLong inputDimension(3);
    UnsignedLong outputDimension(2);
    // Center
    NumericalPoint center(inputDimension);
    center[0] = -1;
    center[1] = 0.5;
    center[2] = 1;
    // Constant term
    NumericalPoint constant(outputDimension);
    constant[0] = -1.0;
    constant[1] =  2.0;
    // Linear term
    Matrix linear(inputDimension, outputDimension);
    linear(0,0) = 1.0;
    linear(1,0) = 2.0;
    linear(2,0) = 3.0;
    linear(0,1) = 4.0;
    linear(1,1) = 5.0;
    linear(2,1) = 6.0;

    LinearNumericalMathEvaluationImplementation myFunction(center, constant, linear);
    myFunction.setName("linearFunction");
    NumericalPoint inPoint(inputDimension);
    inPoint[0] = 7.0;
    inPoint[1] = 8.0;
    inPoint[2] = 9.0;
    NumericalPoint outPoint = myFunction( inPoint );
    std::cout << "myFunction=" << myFunction << std::endl;
    std::cout << myFunction.getName() << "( " << inPoint << " ) = " << outPoint << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
