//                                               -*- C++ -*-
/**
 *  @file  t_MatrixSolveLinearSystem_std.cxx
 *  @brief The test file for the solveLinearSystem method of the Matrix class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_MatrixSolveLinearSystem_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "Matrix.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  // First an n by n case  
  Matrix matrix1(2,2);
  matrix1.setName("matrix1");
  matrix1(0,0)=1. ;
  matrix1(1,0)=2. ;
  matrix1(0,1)=5. ;
  matrix1(1,1)=12. ;
  std::cout << "matrix1 = " << matrix1 << std::endl;
  
  NumericalPoint pt1 ;
  pt1.add(5.) ;
  pt1.add(0.) ;
  std::cout << "pt1 = " << pt1 << std::endl;
  
  NumericalPoint result1 ;
  result1 = matrix1.solveLinearSystem(pt1);
  std::cout << "result1 = " << result1 << std::endl;
  // Second an n by p case, n < p
  Matrix matrix2(2,3);
  matrix2.setName("matrix2");
  matrix2(0,0)=1. ;
  matrix2(1,0)=2. ;
  matrix2(0,1)=5. ;
  matrix2(1,1)=12. ;
  matrix2(0,2)=3. ;
  matrix2(1,2)=4. ;
  std::cout << "matrix2 = " << matrix2 << std::endl;
  
  NumericalPoint pt2 ;
  pt2.add(5.) ;
  pt2.add(0.) ;
  std::cout << "pt2 = " << pt2 << std::endl;
  
  NumericalPoint result2 ;
  result2 = matrix2.solveLinearSystem(pt2);
  std::cout << "result2 = " << result2 << std::endl;
  // Third an n by p case, n > p
  Matrix matrix3(3,2);
  matrix3.setName("matrix3");
  matrix3(0,0)=1. ;
  matrix3(1,0)=2. ;
  matrix3(2,0)=4. ;
  matrix3(0,1)=5. ;
  matrix3(1,1)=12. ;
  matrix3(2,1)=3. ;

  std::cout << "matrix3 = " << matrix3 << std::endl;
  
  NumericalPoint pt3 ;
  pt3.add(5.) ;
  pt3.add(0.) ;
  pt3.add(1.) ;
  std::cout << "pt3 = " << pt3 << std::endl;
  
  NumericalPoint result3 ;
  result3 = matrix3.solveLinearSystem(pt3);
  std::cout << "result3 = " << result3 << std::endl;

  return ExitCode::Success;
}
