//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_composition.cxx
 *  @brief The test file of class NumericalMathFunction for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_NumericalMathFunction_composition.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <iomanip>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    /** Left hand side of the composition */
    NumericalMathFunction left("TestCompositionLeft");

    /** Right hand side of the composition */
    NumericalMathFunction right("TestCompositionRight");

    /** Compositon of left and right */
    NumericalMathFunction composed(left, right);

    std::cout << "right=" << right << std::endl;
    std::cout << "left=" << left << std::endl;
    std::cout << "composed=" << composed << std::endl;

    /** Does it worked? */
    NumericalPoint x(right.getInputNumericalPointDimension(), 1.0);
    NumericalPoint y(right(x));
    NumericalPoint z(left(y));
    Matrix Dy(right.gradient(x));
    Matrix Dz(left.gradient(y));

    std::cout << "x=" << x << " y=right(x)=" << y << " z=left(y)=" << z << std::endl;
    std::cout << "left(right(x))=" << composed(x) << std::endl;
    std::cout << "D(right)(x)=" << Dy << " D(left)(y)=" << Dz;
    std::cout << " prod=" << Dy * Dz << std::endl;
    std::cout << "D(left(right(x)))=" << composed.gradient(x) << std::endl;
    SymmetricTensor result(composed.hessian(x));
    std::cout << "DD(left(right(x)))=" << std::endl;
    for(UnsignedLong k = 0; k < result.getNbSheets(); k++)
      {
	for(UnsignedLong j = 0; j < result.getNbColumns(); j++)
	  {
	    for(UnsignedLong i = 0; i < result.getNbRows(); i++)
	      {
		std::cout << std::setw(14) << std::scientific << std::right << result(i, j, k);
	      }
	    std::cout << std::endl;
	  }
	std::cout << std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
