//                                               -*- C++ -*-
/**
 *  @file  t_NumericalSample_big.cxx
 *  @brief The test file of class NumericalSample of big size
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_NumericalSample_big.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    {
      // We create an empty NumericalSample
      NumericalSample sample(0, 2);
      sample.setName("EmptySample");
      std::cout << "sample=" << sample << std::endl;

      try {
	// We access the element of the sample
	NumericalPoint p(sample[0]);
	std::cout << "p=" << p << std::endl;

	// We should NEVER go here
	throw TestFailed("Exception NOT thrown");
      }
      catch (OutOfBoundException & ex) {
	// Nothing to do
      }
    }


    {
      // We create an small NumericalSample
      NumericalSample sample(1, 2);
      sample.setName("SmallSample");
      std::cout << "sample=" << sample << std::endl;

      // We access the element of the sample
      NumericalPoint p(sample[0]);
      std::cout << "p=" << p << std::endl;
      try {
	// We try to access past the last element of the point
	std::cout << "p[0]=" << p[0] 
		  << " p[1]=" << p[1]
		  << " p[2]=" << p[2]
		  << std::endl;

	// We should NEVER go here
	throw TestFailed("Exception NOT thrown");
      }
      catch (OutOfBoundException & ex) {
	// Nothing to do
      }
    }


    {
      // We create a big NumericalSample
      NumericalSample sample(1000000, 2);
      sample.setName("BigSample");

      // We populate the sample
      UnsignedLong size(sample.getSize());
      for(UnsignedLong i=0; i<size; i++) {
	sample[i] = NumericalPoint(2, i);
      }

      std::cout << "sample first point=" << sample[0]      << std::endl;
      std::cout << "sample last  point=" << sample[size-1] << std::endl;
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
