//                                               -*- C++ -*-
/**
 *  @file  t_SQP_std.cxx
 *  @brief The test file of class SQP for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_SQP_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "SQP.hxx"

using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Optimisation;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    try {
      // Test function operator ()
      NumericalMathFunction levelFunction("TestOptimLinear");
      SQP::SpecificParameters specific;


      NumericalPoint startingPoint(4, 1.0);
      SQP mySQPAlgorithm(specific, levelFunction);
      mySQPAlgorithm.setStartingPoint(startingPoint);
      mySQPAlgorithm.setLevelValue(3.0);
      mySQPAlgorithm.setMaximumIterationsNumber(100);
      mySQPAlgorithm.setMaximumAbsoluteError(1.0e-10);
      mySQPAlgorithm.setMaximumRelativeError(1.0e-10);
      mySQPAlgorithm.setMaximumResidualError(1.0e-10);
      mySQPAlgorithm.setMaximumConstraintError(1.0e-10);
      std::cout << "mySQPAlgorithm=" << mySQPAlgorithm << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.str());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
