//                                               -*- C++ -*-
/**
 *  @file  t_Secant_std.cxx
 *  @brief The test file of class Secant for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_Secant_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "Secant.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Solver;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    /** Analytical construction */
    Description input(1);
    input[0] = "x";
    Description output(1);
    output[0] = "y";
    Description formulas(output.getSize());
    formulas[0] = "x-cos(x)";
    NumericalMathFunction analytical(input, output, formulas);
    Secant myAlgo;
    std::cout << "myAlgo=" << myAlgo << std::endl;
    NumericalScalar value(0.0);
    std::cout << "Solve " << formulas[0] << "=" << value << " for " << input[0] << std::endl;
    std::cout << "x=" << myAlgo.solve(analytical, value, 0.0, 3.0) << std::endl;
    std::cout << "myAlgo=" << myAlgo.str() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
