//                                               -*- C++ -*-
/**
 *  @file  t_SquareMatrix_std.cxx
 *  @brief The test file of class SquareMatrix for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_SquareMatrix_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "SquareMatrix.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  
  /** TEST NUMBER ZERO : DEFAULT CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number zero : default constructor and string converter" << std::endl;
  
  /* Default constructor */
  SquareMatrix squareMatrix0;
  
  /* String converter */
  std::cout << "squareMatrix0 = " << squareMatrix0 << std::endl;
  

  /** TEST NUMBER ONE : CONSTRUCTOR WITH SIZE, OPERATOR() AND STRING CONVERTER */
  std::cout << "test number one : constructor with size, operator() and string converter" << std::endl;
  
  /* Constructor with size */
  SquareMatrix squareMatrix1(2);
  
  /* Check operator() methods */
  squareMatrix1(0,0)=1. ;
  squareMatrix1(1,0)=2. ;
  squareMatrix1(0,1)=3. ;
  squareMatrix1(1,1)=4. ;
    
  /* String converter */
  std::cout << "squareMatrix1 = " << squareMatrix1 << std::endl;
  

  /** TEST NUMBER TWO : COPY CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number two : copy constructor and string converter" << std::endl;
  
  /* Copy constructor */
  SquareMatrix squareMatrix2(squareMatrix1);
  
  /* String converter */
  std::cout << "squareMatrix2 = " << squareMatrix2 << std::endl;
  
  
  /** TEST NUMBER THREE : GET DIMENSIONS METHODS */
  std::cout << "test number three : get dimensions methods" << std::endl;
  
  /* Get dimension methods */
  std::cout << "squareMatrix1's nbRows = " << squareMatrix1.getNbRows() << std::endl
	    << "squareMatrix1's nbColumns = " << squareMatrix1.getNbColumns() << std::endl;
	    
#if 0	    
  /** TEST NUMBER FOUR : SET DIMENSIONS METHOD */
  std::cout << "test number four : set dimensions method" << std::endl;
  
  /* Set dimension methods */
  squareMatrix0.setUniqueDimension(2);
  std::cout << "squareMatrix0's nbRows = " << squareMatrix0.getNbRows() << std::endl
	    << "squareMatrix0's nbColumns = " << squareMatrix0.getNbColumns() << std::endl;
#endif
	      
	    
  /** TEST NUMBER FIVE : ASSIGNMENT METHOD */
  std::cout << "test number five : assignment method" << std::endl;
  
  /* Assignment method */
  SquareMatrix squareMatrix3 ;
  squareMatrix3 = squareMatrix1 ;
  std::cout << "squareMatrix3 = " << squareMatrix3 << std::endl;
  
  /** TEST NUMBER SIX : TRANSPOSITION METHOD */
  std::cout << "test number six : transposition method" << std::endl;
  
  /* Check transpose method */
  SquareMatrix squareMatrix4 = squareMatrix1.transpose();
  std::cout << "squareMatrix1 transposed = " << squareMatrix4 << std::endl;
  std::cout << "squareMatrix1 transposed = " << squareMatrix1.transpose() << std::endl;
  
  /** TEST NUMBER SEVEN : ADDITION METHOD */
  std::cout << "test number seven : addition method" << std::endl;
  
  /* Check addition method : we check the operator and the symmetry of the operator, thus testing the comparison operator */
  SquareMatrix sum1 = squareMatrix1.operator+( squareMatrix4 ) ;
  SquareMatrix sum2 = squareMatrix4.operator+( squareMatrix1 ) ;
  std::cout << "sum1 = " << sum1 << std::endl;
  std::cout << "sum2 = " << sum2 << std::endl;
  std::cout << "sum1 equals sum2 = " << (sum1 == sum2) << std::endl;
  
  
  /** TEST NUMBER EIGHT : SUBSTRACTION METHOD */
  std::cout << "test number eight : substraction method" << std::endl;
  
  /* Check substraction method */
  SquareMatrix diff = squareMatrix1.operator-( squareMatrix4 ) ;
  std::cout << "diff = " << diff << std::endl;
  
  
  /** TEST NUMBER NINE : MATRIX MULTIPLICATION METHOD */
  std::cout << "test number nine : matrix multiplication method" << std::endl;
  
  /* Check multiplication method */
  SquareMatrix prod = squareMatrix1.operator*( squareMatrix4 ) ;
  std::cout << "prod = " << prod << std::endl;
  
  
  /** TEST NUMBER TEN : MULTIPLICATION WITH A NUMERICAL POINT METHOD */
  std::cout << "test number ten : multiplication with a numerical point method" << std::endl;
  
  /* Create the numerical point */
  NumericalPoint pt ;
  pt.add(1.) ;
  pt.add(2.) ;
  std::cout << "pt = " << pt << std::endl;
  
  /* Check the product method */
  NumericalPoint ptResult = squareMatrix1.operator*( pt )  ;
  std::cout << "ptResult = " << ptResult << std::endl;
  
  /** TEST NUMBER ELEVEN : MULTIPLICATION AND DIVISION BY A NUMERICAL SCALAR METHODS */
  std::cout << "test number eleven : multiplication and division by a numerical scalar methods" << std::endl;
  
  /* Check the multiplication method */ 
  double s=3.;
  SquareMatrix scalprod1 = squareMatrix1.operator*(s) ;
  SquareMatrix scalprod2 = s * squareMatrix1 ;
  std::cout << "scalprod1 = " << scalprod1 << std::endl;
  std::cout << "scalprod2 = " << scalprod2 << std::endl;
  std::cout << "scalprod1 equals scalprod2 = " << (scalprod1 == scalprod2) << std::endl;
  
  /* Check the division method */
  SquareMatrix scaldiv1 = squareMatrix1.operator/(s) ;
  SquareMatrix scaldiv2 = squareMatrix1.operator*(1/s) ;
  std::cout << "scaldiv1 = " << scaldiv1 << std::endl;
  std::cout << "scaldiv2 = " << scaldiv2 << std::endl;
  std::cout << "scaldiv1 equals scaldiv2 = " << (scaldiv1 == scaldiv2) << std::endl;
  
  
  /** TEST NUMBER TWELVE : ISEMPTY METHOD */
  std::cout << "test number twelve : isEmpty method" << std::endl;
  
  /* Check method isEmpty */
  SquareMatrix squareMatrix5;
  std::cout << "squareMatrix0 is empty = " << squareMatrix0.isEmpty() << std::endl
            << "squareMatrix1 is empty = " << squareMatrix1.isEmpty() << std::endl
	    << "squareMatrix5 is empty = " << squareMatrix5.isEmpty() << std::endl;

	    
  return ExitCode::Success;
}
