//                                               -*- C++ -*-
/**
 *  @file  t_SymmetricMatrixLapack_std.cxx
 *  @brief The test file for the Lapack based methods of the SquareMatrix class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_SymmetricMatrixLapack_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "SymmetricMatrix.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  
  SymmetricMatrix matrix1(2);
  matrix1.setName("matrix1");
  matrix1(0,0)=1. ;
  matrix1(0,1)=5. ;
  matrix1(1,0)=5. ;
  matrix1(1,1)=12. ;
  std::cout << "matrix1 = " << matrix1 << std::endl;
  
  NumericalPoint pt ;
  pt.add(5.) ;
  pt.add(0.) ;
  std::cout << "pt = " << pt << std::endl;
  
  NumericalPoint result ;
  result = matrix1.solveLinearSystem(pt);
  std::cout << "result = " << result << std::endl;
  
  NumericalScalar determinant ;
  determinant = matrix1.computeDeterminant();
  std::cout << "determinant = " << determinant << std::endl;
  
  Collection<NumericalScalar> ev(2);
  ev = matrix1.computeEigenValues().getCollection();
  std::cout << "ev = " << ev << std::endl;

  return ExitCode::Success;
}
