//                                               -*- C++ -*-
/**
 *  @file  t_VisualTest_std.cxx
 *  @brief The test file of class VisualTest
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_VisualTest_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "VisualTest.hxx"
#include "NumericalSample.hxx"
#include "Normal.hxx"
#include "Beta.hxx"
#include "Gamma.hxx"
#include "IdentityMatrix.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"
#include "Graph.hxx"
#include "LinearModelFactory.hxx"
#include "LinearModel.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::StatTest;
using namespace OT::Base::Graph;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();
  
  /* Generate a Normal sample */
  Normal normal(1);
  UnsignedLong size(100);
  NumericalSample sample(normal.getNumericalSample(size));
  Graph sampleCDF(VisualTest::DrawEmpiricalCDF(sample, sample.getMin()[0] - 1.0, sample.getMax()[0] + 1.0));
  sampleCDF.draw("sampleCDF", 640, 480);
  std::cout << "bitmap = " << sampleCDF.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleCDF.getPostscript() << std::endl;
    
  sampleCDF = VisualTest::DrawEmpiricalCDF(sample, -0.5, 0.5);
  sampleCDF.draw("sampleCDFZoom", 640, 480);
  std::cout << "bitmap = " << sampleCDF.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleCDF.getPostscript() << std::endl;

  Graph sampleHist(VisualTest::DrawHistogram(sample, 10));
  sampleHist.draw("sampleHist", 640, 480);
  std::cout << "bitmap = " << sampleHist.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleHist.getPostscript() << std::endl;
 
  sampleHist = VisualTest::DrawHistogram(sample);
  sampleHist.draw("sampleHistOpt", 640, 480);
  std::cout << "bitmap = " << sampleHist.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleHist.getPostscript() << std::endl;

  NumericalSample sample2(Gamma(3.0, 4.0, 0.0).getNumericalSample(size));
  Graph twoSamplesQQPlot(VisualTest::DrawQQplot(sample, sample2, 100));
  twoSamplesQQPlot.draw("twoSamplesQQPlot", 640, 480);
  std::cout << "bitmap = " << twoSamplesQQPlot.getBitmap() << std::endl;
  std::cout << "postscript = " << twoSamplesQQPlot.getPostscript() << std::endl;

  UnsignedLong dimension(2);
  CorrelationMatrix R(dimension);
  R(0, 1) = 0.8;
  Normal distribution(NumericalPoint(dimension, 3.0), NumericalPoint(dimension, 2.0), R);
  NumericalSample sample2D(distribution.getNumericalSample(size));
  NumericalSample firstSample(size, 1);
  NumericalSample secondSample(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      firstSample[i][0] = sample2D[i][0];
      secondSample[i][0] = sample2D[i][1];
    }
  LinearModel lmtest(LinearModelFactory().buildLM(firstSample, secondSample));
  Graph drawLMVTest(VisualTest::DrawLMVisualTest(firstSample, secondSample, lmtest));
  drawLMVTest.draw("LMV", 640, 480);
  std::cout << "bitmap = " << drawLMVTest.getBitmap() << std::endl;
  std::cout << "postscript = " << drawLMVTest.getPostscript() << std::endl;
    
  Graph drawLMRTest(VisualTest::DrawLMResidualTest(firstSample, secondSample, lmtest));
  drawLMRTest.draw("LMR", 640, 480);   
  std::cout << "bitmap = " << drawLMRTest.getBitmap() << std::endl;
  std::cout << "postscript = " << drawLMRTest.getPostscript() << std::endl;

  Graph sampleSampleClouds(VisualTest::DrawClouds(sample2D, Normal(NumericalPoint(dimension, 2.0), NumericalPoint(dimension, 3.0), R).getNumericalSample(size / 2)));
  sampleSampleClouds.draw("sampleSampleClouds", 640, 480);
  std::cout << "bitmap = " << sampleSampleClouds.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleSampleClouds.getPostscript() << std::endl;
    
  Graph sampleDistributionClouds(VisualTest::DrawClouds(sample2D, Normal(NumericalPoint(dimension, 2.5), NumericalPoint(dimension, 1.0), R)));
  sampleDistributionClouds.draw("sampleDistributionClouds", 640, 480);
  std::cout << "bitmap = " << sampleDistributionClouds.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleDistributionClouds.getPostscript() << std::endl;
    
  Graph sampleDistributionQQPlot(VisualTest::DrawQQplot(sample, normal, 100));
  sampleDistributionQQPlot.draw("sampleDistributionQQPlot", 640, 480);
  std::cout << "bitmap = " << sampleDistributionQQPlot.getBitmap() << std::endl;
  std::cout << "postscript = " << sampleDistributionQQPlot.getPostscript() << std::endl;
    
  Graph henryPlot(VisualTest::DrawHenryLine(sample));
  henryPlot.draw("HenryPlot", 640, 480);
  std::cout << "bitmap = " << henryPlot.getBitmap() << std::endl;
  std::cout << "postscript = " << henryPlot.getPostscript() << std::endl;
    
  
  
  return ExitCode::Success;
}
