// SWIG file Cobyla.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2007-04-04 18:49:00 +0200 (mer 04 avr 2007) $
// Id : $Id: Cobyla.i 407 2007-04-04 16:49:00Z dutka $

%{
#include "Cobyla.hxx"
%}

%include Cobyla.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * @class CobylaSpecificParameters
 * Specific parameters of the cobyla library
 */
class CobylaSpecificParameters: public
  OpenTURNS::Base::Common::PersistentObject
{
  static const NumericalScalar DEFAULT_RHOBEG;

  CLASSNAME;
public:
  /* Default constructor */
  CobylaSpecificParameters();

  /* Parameters constructor */
  CobylaSpecificParameters(const NumericalScalar rhoBeg);

  /* Copy constructor */
  CobylaSpecificParameters(const CobylaSpecificParameters & other);

  /* Virtual constructor */
  virtual CobylaSpecificParameters * clone() const;

  /* Destructor */
  virtual ~CobylaSpecificParameters();

  /* RhoBeg accessor */
  NumericalScalar getRhoBeg() const;

  /* RhoBeg accessor */
  void setRhoBeg(const NumericalScalar rhoBeg);

  /* String converter */
  String str() const;

}; /* class CobylaSpecificParameters */

}}}
namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend Cobyla { Cobyla(const Cobyla & other) { return new OpenTURNS::Base::Optimisation::Cobyla(other); } } }}}
