// SWIG file NearestPointChecker.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu 10 mai 2007) $
// Id : $Id: NearestPointChecker.i 434 2007-05-10 14:43:31Z dutka $

%{
#include "NearestPointChecker.hxx"
%}

%include NearestPointChecker.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * @class NearestPointCheckerResult
 * NearestPointCheckerResult stores the test result 
 */
class NearestPointCheckerResult: public
  OpenTURNS::Base::Common::PersistentObject
{
  CLASSNAME;
public:
  /* Default constructor */
  NearestPointCheckerResult();

  /* Standard constructor */
  NearestPointCheckerResult(const Stat::NumericalSample & verifyingConstraintPoints,
                            const Stat::NumericalSample & verifyingConstraintValues,
                            const Stat::NumericalSample & violatingConstraintPoints,
                            const Stat::NumericalSample & violatingConstraintValues);

  /* Copy constructor */
  NearestPointCheckerResult(const NearestPointCheckerResult & other);

  /* Virtual constructor */
  virtual NearestPointCheckerResult * clone() const;

  /* Destructor */
  virtual ~NearestPointCheckerResult();

  /* verifyingConstraintPoints accessor */
  Stat::NumericalSample  getVerifyingConstraintPoints() const;
  /* verifyingConstraintValues accessor */
  Stat::NumericalSample  getVerifyingConstraintValues() const;
  /* violatingConstraintPoints accessor */
  Stat::NumericalSample  getViolatingConstraintPoints() const;
  /* violatingConstraintValues accessor */
  Stat::NumericalSample  getViolatingConstraintValues() const;
  /* verifyingConstraintPoints accessor */
  void setVerifyingConstraintPoints(const Stat::NumericalSample & verifyingConstraintPoints);

  /* verifyingConstraintValues accessor */
  void setVerifyingConstraintValues(const Stat::NumericalSample & verifyingConstraintValues);

  /* violatingConstraintPoints accessor */
  void setViolatingConstraintPoints(const Stat::NumericalSample & violatingConstraintPoints);

  /* violatingConstraintValuess accessor */
  void setViolatingConstraintValues(const Stat::NumericalSample & violatingConstraintValues);

  /* String converter */
  String str() const;

}; // class NearestPointCheckerResult

%extend NearestPointCheckerResult {
  const String __str__() const { return self->str(); }
}

%extend NearestPointChecker {
  NearestPointChecker(const NumericalMathFunction & levelFunction,
                      const Common::ComparisonOperatorImplementation & p_comparisonOperator,
                      const NumericalScalar threshold,
	              const NumericalSample & sample)
  { return new OT::Base::Optimisation::NearestPointChecker(levelFunction, p_comparisonOperator, threshold, sample); }

  const String __str__() const { return self->str(); }
}

}}}
namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend NearestPointChecker { NearestPointChecker(const NearestPointChecker & other) { return new OpenTURNS::Base::Optimisation::NearestPointChecker(other); } } }}}
