// SWIG file OTexceptions.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2006-12-07 10:38:09 +0100 (jeu 07 déc 2006) $
// Id : $Id: OTexceptions.i 258 2006-12-07 09:38:09Z dutka $

%{
#include "ExceptionDefs.hxx"
#include "Exception.hxx"
%}

namespace std {
  class exception
  {
  public:
    exception() throw() { }
    virtual ~exception() throw();
    /** Returns a C-style character string describing the general cause
     *  of the current error.  */
    virtual const char* what() const throw();
  };
}

%include exception.i
%include ExceptionDefs.hxx
%include Exception.hxx

%template(FileNotFoundException) OpenTURNS::Base::Common::UserException<0>; 
%template(InternalException) OpenTURNS::Base::Common::UserException<1>; 
%template(InvalidArgumentException) OpenTURNS::Base::Common::UserException<2>; 
%template(InvalidDimensionException) OpenTURNS::Base::Common::UserException<3>; 
%template(NoWrapperFileFoundException) OpenTURNS::Base::Common::UserException<4>; 
%template(NotYetImplementedException) OpenTURNS::Base::Common::UserException<5>; 
%template(OutOfBoundException) OpenTURNS::Base::Common::UserException<6>; 
%template(WrapperFileParsingException) OpenTURNS::Base::Common::UserException<7>; 
%template(WrapperInternalException) OpenTURNS::Base::Common::UserException<8,OpenTURNS::Base::Common::InternalException>; 
%template(XMLException) OpenTURNS::Base::Common::UserException<9>; 
%template(XMLParserException) OpenTURNS::Base::Common::UserException<10>; 
%template(DynamicLibraryException) OpenTURNS::Base::Common::UserException<11>; 
%template(NotSymmetricDefinitePositiveException) OpenTURNS::Base::Common::UserException<12>; 
%template(InvalidRangeException) OpenTURNS::Base::Common::UserException<13>; 
%template(NotDefinedException) OpenTURNS::Base::Common::UserException<14>; 
%template(NetworkException) OpenTURNS::Base::Common::UserException<15>; 
%template(RException) OpenTURNS::Base::Common::UserException<16>; 

%exception {
  try {
    $action
  }
  catch (OT::Base::Common::Exception & ex) {
    SWIG_exception(SWIG_RuntimeError,ex.str().c_str());
  }
  catch (std::exception & ex) {
    SWIG_exception(SWIG_RuntimeError,ex.what());
  }
}


%pythoncode %{
class TestFailed:
  """
  TestFailed is used to raise an uniform exception in tests
  """
  __type = "TestFailed"
  def __init__(self,reason=""):
    self.reason = reason
  def type(self):
    return TestFailed.__type
  def what(self):
    return self.reason
  def __str__(self):
    return TestFailed.__type + ": " + self.reason
  def __lshift__(self,ch):
    self.reason += ch
    return self
%}

