// SWIG file SQP.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
// Id : $Id: SQP.i 862 2008-06-26 11:50:17Z dutka $

%{
#include "SQP.hxx"
%}

%include SQP.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * @class SQPSpecificParameters
 * Specific parameters of the cobyla library
 */
class SQPSpecificParameters: public
  OpenTURNS::Base::Common::PersistentObject
{
  /* Multiplicative decrease of linear step */
  static const NumericalScalar DEFAULT_TAU;
  /* Armijo factor */
  static const NumericalScalar DEFAULT_OMEGA;
  /* Growing factor in penalization term */
  static const NumericalScalar DEFAULT_SMOOTH;

  CLASSNAME;
public:
  /* Default constructor */
  SQPSpecificParameters();

  /* Parameters constructor */
  SQPSpecificParameters(const NumericalScalar tau, const NumericalScalar omega, const NumericalScalar smooth);

  /* Copy constructor */
  SQPSpecificParameters(const SQPSpecificParameters & other);

  /* Virtual constructor */
  virtual SQPSpecificParameters * clone() const;

  /* Destructor */
  virtual ~SQPSpecificParameters();

  /* Tau accessor */
  NumericalScalar getTau() const;

  /* Tau accessor */
  void setTau(const NumericalScalar tau);

  /* Omega accessor */
  NumericalScalar getOmega() const;

  /* Omega accessor */
  void setOmega(const NumericalScalar tau);

  /* Smooth accessor */
  NumericalScalar getSmooth() const;

  /* Smooth accessor */
  void setSmooth(const NumericalScalar tau);

  /* String converter */
  String str() const;

}; /* class SQPSpecificParameters */

}}}
namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend SQP { SQP(const SQP & other) { return new OpenTURNS::Base::Optimisation::SQP(other); } } }}}
