// SWIG file Simulation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
// Id : $Id: Simulation.i 995 2008-10-31 10:52:04Z dutka $

%{
#include "Simulation.hxx"
%}

%include Simulation.hxx

namespace OpenTURNS { namespace Uncertainty { namespace Algorithm {

/*
 * @class SimulationResult
 * SimulationResult stores the simulation result 
 */
class SimulationResult: public
  OpenTURNS::Base::Common::PersistentObject
{

  static const NumericalScalar DEFAULT_CONFIDENCE_LEVEL = 0.95;

  CLASSNAME;
public:

  /* Default constructor */
  explicit SimulationResult();

  /* Standard constructor */
  SimulationResult(const NumericalScalar probabilityEstimate,
	           const NumericalScalar varianceEstimate,
	           const UnsignedLong outerSampling,
	           const UnsignedLong blockSize)
    throw(Algorithm::Simulation::InvalidArgumentException);

  /* Copy constructor */
  SimulationResult(const SimulationResult & other);

  /* Virtual constructor */
  virtual SimulationResult * clone() const;

  /* Destructor */
  virtual ~SimulationResult();

  /* Probability estimate accessor */
  NumericalScalar getProbabilityEstimate() const;

  /* Variance estimate accessor */
  NumericalScalar getVarianceEstimate() const;

  /* Coefficient of variation estimate accessor */
  NumericalScalar getCoefficientOfVariation() const;

  /* Sample size accessor */
  UnsignedLong getOuterSampling() const;

  /* Block size accessor */
  UnsignedLong getBlockSize() const;

  /* Confidence length */
  NumericalScalar getConfidenceLength(const NumericalScalar level) const
    throw(Algorithm::Simulation::InvalidArgumentException);

  /* String converter */
  String str() const;

}; // class SimulationResult

}}}
namespace OpenTURNS{ namespace Uncertainty { namespace Algorithm { %extend Simulation { Simulation(const Simulation & other) { return new OpenTURNS::Uncertainty::Algorithm::Simulation(other); } } }}}
