// SWIG file ot.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-08-28 17:36:47 +0200 (Thu, 28 Aug 2008) $
// Id : $Id: openturns.i 916 2008-08-28 15:36:47Z dutka $

%define DOCSTRING
"Open TURNS is a set of tools and algorithms to realize uncertainty analysis."
%enddef

%module(docstring=DOCSTRING) ot
%feature("autodoc","1");

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%pythoncode %{
#from openturns_viewer import ViewImage,StopViewer,WaitForViewer

def TESTPREAMBLE():
  """
  TESTPREAMBLE() catches the --version argument on the command line,
  prints a identification string and then exits softly.
  """
  import sys
  if "--version" in sys.argv:
    print sys.argv[0] + " : $Id: openturns.i 916 2008-08-28 15:36:47Z dutka $"
    sys.exit(0)
%}

%pythoncode %{
def Show(graph):
  try :
    if (Graph(graph).getClassName()=="Graph"):
      from rpy import r
      tmp=r(graph.getRCommand())
      graph.clean()
  except :
    try :
      if (Drawable(graph).getClassName()=="Drawable"):
        from rpy import r
        tmp=r(graph.draw())
        graph.clean()
    except :
      import sys
      print "Error in Show", sys.exc_type, sys.exc_value
%}

/* Base/Common */
%include Object.i
%include PersistentObject.i
%include SharedPointer.i
%include Pointer.i
%include InterfaceObject.i
%include TypedInterfaceObject.i
%include TypedCollectionInterfaceObject.i
%include Study.i
%include StorageManager.i
%include XMLStorageManager.i
%include Log.i
%include ResourceMap.i
%include ComparisonOperatorImplementation.i
%include ComparisonOperator.i
%include Equal.i
%include Greater.i
%include GreaterOrEqual.i
%include Less.i
%include LessOrEqual.i
%include Threadable.i
%include PlatformInfo.i

/* Base/Type */
%include Collection.i
%include PersistentCollection.i
%include DescriptionImplementation.i
%include Description.i
%include NumericalPointImplementation.i
%include NumericalPoint.i
%include NumericalPointImplementationWithDescription.i
%include NumericalPointWithDescription.i
%include Indices.i
%include Interval.i
%include MatrixImplementation.i
%include Matrix.i
%include SquareMatrix.i
%include SymmetricMatrix.i
%include TensorImplementation.i
%include Tensor.i
%include SymmetricTensor.i
%include Cache.i

/* Base/Stat */
%include CovarianceMatrix.i
%include CorrelationMatrix.i
%include IdentityMatrix.i
%include NumericalSample.i
%include HistoryStrategyImplementation.i
%include HistoryStrategy.i
%include Compact.i
%include Full.i
%include Last.i
%include Null.i
%include ConfidenceInterval.i
%include LinearModel.i
%include LinearModelFactory.i
%include TestResult.i
%include RandomGenerator.i
%include CorrelationAnalysis.i
%include SensitivityAnalysis.i

/* Base/Func */
%include WrapperData.i
%include WrapperFile.i
%include NumericalMathEvaluationImplementation.i
%include NumericalMathGradientImplementation.i
%include NumericalMathHessianImplementation.i
%include NoNumericalMathEvaluationImplementation.i
%include NoNumericalMathGradientImplementation.i
%include NoNumericalMathHessianImplementation.i
%include LinearNumericalMathEvaluationImplementation.i
%include LinearNumericalMathGradientImplementation.i
%include QuadraticNumericalMathEvaluationImplementation.i
%include ConstantNumericalMathGradientImplementation.i
%include ConstantNumericalMathHessianImplementation.i
%include ComputedNumericalMathEvaluationImplementation.i
%include ComputedNumericalMathGradientImplementation.i
%include ComputedNumericalMathHessianImplementation.i
%include ComposedNumericalMathEvaluationImplementation.i
%include ComposedNumericalMathGradientImplementation.i
%include ComposedNumericalMathHessianImplementation.i
%include NumericalMathFunctionImplementation.i
%include ComposedNumericalMathFunction.i
%include NumericalMathFunction.i
%include LinearNumericalMathFunction.i

/* Base/Diff */
%include CenteredFiniteDifferenceGradient.i
%include CenteredFiniteDifferenceHessian.i
%include NonCenteredFiniteDifferenceGradient.i

/* Base/Optim */
%include BoundConstrainedAlgorithmImplementation.i
%include BoundConstrainedAlgorithm.i
%include NearestPointAlgorithmImplementation.i
%include NearestPointAlgorithm.i
%include NearestPointChecker.i
%include AbdoRackwitz.i
%include Cobyla.i
%include TNC.i
%include SQP.i

/* Base/Graph */
%include DrawableImplementation.i
%include Drawable.i
%include GraphImplementation.i
%include Graph.i
%include BarPlot.i
%include Cloud.i
%include Contour.i
%include Curve.i
%include Pie.i
%include Staircase.i

/* Base/Solver */
%include SolverImplementation.i
%include Solver.i
%include Bisection.i
%include Secant.i
%include Brent.i

/* Uncertainty/Algorithm */
%include ExperimentImplementation.i
%include Experiment.i
%include Axial.i
%include Composite.i
%include Factorial.i
%include Box.i
%include LinearTaylor.i
%include QuadraticTaylor.i
%include LinearLeastSquares.i
%include QuadraticLeastSquares.i

/* Uncertainty/Model */
%include DistributionImplementation.i
%include DistributionImplementationFactory.i
%include Distribution.i
%include DistributionFactory.i
%include UsualDistribution.i
%include ContinuousDistribution.i
%include EllipticalDistribution.i
%include NonEllipticalDistribution.i
%include DiscreteDistribution.i
%include CopulaImplementation.i
%include Copula.i
%include ArchimedeanCopula.i

/* Uncertainty/Distribution */
%include SpecFunc.i
%include DistFunc.i
%include Beta.i
%include BetaFactory.i
%include Epanechnikov.i
%include Exponential.i
%include ExponentialFactory.i
%include Gamma.i
%include GammaFactory.i
%include Geometric.i
%include GeometricFactory.i
%include Gumbel.i
%include GumbelFactory.i
%include Histogram.i
%include HistogramFactory.i
%include LogNormal.i
%include LogNormalFactory.i
%include Logistic.i
%include LogisticFactory.i
%include MultiNomial.i
%include MultiNomialFactory.i
%include NonCentralStudent.i
%include Normal.i
%include NormalFactory.i
%include Poisson.i
%include PoissonFactory.i
%include Student.i
%include StudentFactory.i
%include Triangular.i
%include TriangularFactory.i
%include TruncatedDistribution.i
%include TruncatedNormal.i
%include TruncatedNormalFactory.i
%include Uniform.i
%include UniformFactory.i
%include UserDefined.i
%include UserDefinedFactory.i
%include Weibull.i
%include WeibullFactory.i
%include IndependentCopula.i
%include NormalCopula.i
%include NormalCopulaFactory.i
%include FrankCopula.i
%include FrankCopulaFactory.i
%include ClaytonCopula.i
%include ClaytonCopulaFactory.i
%include GumbelCopula.i
%include GumbelCopulaFactory.i
%include SklarCopula.i
%include ComposedDistribution.i
%include ComposedCopula.i
%include RandomMixture.i
%include Mixture.i
%include KernelMixture.i
%include KernelSmoothing.i

/* Uncertainty/Model */
%include RandomVectorImplementation.i
%include ConstantRandomVector.i
%include CompositeRandomVector.i
%include UsualRandomVector.i
%include EventRandomVectorImplementation.i
%include RandomVector.i
%include Event.i
%include StandardEvent.i

/* Uncertainty/Algorithm */
%include QuadraticCumul.i
%include MarginalTransformationEvaluation.i
%include MarginalTransformationGradient.i
%include MarginalTransformationHessian.i
%include InverseMarginalTransformationEvaluation.i
%include InverseMarginalTransformationGradient.i
%include InverseMarginalTransformationHessian.i
%include NatafEllipticalCopulaEvaluation.i
%include NatafEllipticalCopulaGradient.i
%include NatafEllipticalCopulaHessian.i
%include InverseNatafEllipticalCopulaEvaluation.i
%include InverseNatafEllipticalCopulaGradient.i
%include InverseNatafEllipticalCopulaHessian.i
%include NatafIndependentCopulaEvaluation.i
%include NatafIndependentCopulaGradient.i
%include NatafIndependentCopulaHessian.i
%include InverseNatafIndependentCopulaEvaluation.i
%include InverseNatafIndependentCopulaGradient.i
%include InverseNatafIndependentCopulaHessian.i
%include NatafEllipticalDistributionEvaluation.i
%include NatafEllipticalDistributionGradient.i
%include NatafEllipticalDistributionHessian.i
%include InverseNatafEllipticalDistributionEvaluation.i
%include InverseNatafEllipticalDistributionGradient.i
%include InverseNatafEllipticalDistributionHessian.i
%include RosenblattEvaluation.i
%include InverseRosenblattEvaluation.i
%include AnalyticalResult.i
%include Analytical.i
%include FORMResult.i
%include FORM.i
%include SORMResult.i
%include SORM.i
%include StrongMaximumTest.i
%include Simulation.i
%include StandardSpaceSimulation.i
%include Wilks.i
%include MonteCarlo.i
%include LHS.i
%include ImportanceSampling.i
%include StandardSpaceControlledImportanceSampling.i
%include StandardSpaceImportanceSampling.i
%include RootStrategyImplementation.i
%include RootStrategy.i
%include SamplingStrategyImplementation.i
%include SamplingStrategy.i
%include DirectionalSampling.i
%include OrthogonalDirection.i
%include RandomDirection.i
%include MediumSafe.i
%include RiskyAndFast.i
%include SafeAndSlow.i

/* Uncertainty/StatTests */
%include VisualTest.i
%include FittingTest.i
%include HypothesisTest.i
%include LinearModelTest.i
%include NormalityTest.i

/* At last we include template definitions */
%include TemplateDefs.i
