#! /usr/bin/env python

from openturns import *
from math import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    # Instanciate one distribution object
    dim = 2
    copula = FrankCopula(2.5)
    print "Copula " , copula 
    print "Mean " , copula.getMean() 
    print "Covariance " , copula.getCovariance() 

    # Is this copula an elliptical distribution?
    print "Elliptical distribution= " , copula.isElliptical() 

    # Is this copula elliptical ?
    print "Elliptical copula= " , copula.hasEllipticalCopula()

    # Is this copula independent ?
    print "Independent copula= " , copula.hasIndependentCopula() 

    # Test for realization of distribution
    oneRealization = copula.getRealization()
    print "oneRealization=", oneRealization

    # Test for sampling
    size = 10
    oneSample = copula.getNumericalSample( size )
    print "oneSample=", oneSample

   # Test for sampling
    size = 10000
    anotherSample = copula.getNumericalSample( size )
    print "anotherSample mean=", anotherSample.computeMean()
    print "anotherSample covariance=", anotherSample.computeCovariance()
    
    # Define a point
    point = NumericalPoint(dim, 0.2)

    # Show PDF and CDF of point 
    pointPDF = copula.computePDF( point )
    pointCDF = copula.computeCDF( point )
    print "Point = ", point, " pdf=%.6f" % pointPDF, " cdf=%.6f" % pointCDF

    # Get 50% quantile
    quantile = copula.computeQuantile( 0.5 )
    print "Quantile=", quantile
    print "CDF(quantile)=%.6f" % copula.computeCDF(quantile)

    # Extract the marginals
    for i in range(dim) :
      margin = copula.getMarginal(i)
      print "margin=", margin 
      print "margin PDF=%.6f" % margin.computePDF( NumericalPoint(1,0.25))
      print "margin CDF=%.6f" % margin.computeCDF(NumericalPoint(1,0.25))
      print "margin quantile=", margin.computeQuantile(0.95) 
      print "margin realization=", margin.getRealization() 

    # Extract a 2-D marginal
    indices = Indices(2, 0)
    indices[0] = 1
    indices[1] = 0
    print "indices=", indices
    margins = copula.getMarginal(indices)
    print "margins=", margins
    print "margins PDF=%.6f" % margins.computePDF(NumericalPoint(2,0.25))
    print "margins CDF=%.6f" % margins.computeCDF(NumericalPoint(2,0.25))
    quantile = NumericalPoint(margins.computeQuantile(0.95))
    print "margins quantile=", quantile
    print "margins CDF(qantile)=%.6f" % margins.computeCDF(quantile)
    print "margins realization=", margins.getRealization() 

except :
   import sys
   print "t_NormalCopula_std.py", sys.exc_type, sys.exc_value
